import React from 'react';
import ReactEchartsCore from 'echarts-for-react/lib/core';
import echarts from 'echarts/lib/echarts';
import Container from '@/pages/screen/components/Container';
import moment from 'moment';
import * as services from '@/pages/screen/services';
import { featureEnum } from '@/pages/screen/constants';
import './index.less';

const getOption = (data = [], config = {}) => {
  let radarAxisCount = -1;
  const option = {
    tooltip: {
      // trigger: 'axis',
    },
    // legend: {
    //   data: ['预算分配（Allocated Budget）', '实际开销（Actual Spending）'],
    // },
    radar: {
      name: {
        textStyle: {
          color: '#fff',
        },
      },
      radius: '80%',
      axisLabel: {
        show: true,
        showMinLabel: false,
        color: 'rgba(255, 255, 255, 0.6)',
        formatter(val) {
          if (++radarAxisCount % 30 <= 6) {
            return `${val}%`;
          }
        },
      },
      axisLine: {
        lineStyle: {
          color: 'rgba(49, 212, 213, 0.4)',
        },
      },
      splitLine: {
        lineStyle: {
          color: '#31D4D5',
          width: 0,
        },
      },
      splitArea: {
        areaStyle: {
          color: ['#19262e', '#20343b', '#243b43', '#2c404a', '#324752'],
        },
      },
      indicator: [
        { name: '度电成本同比增幅', max: 100 },
        { name: '度电成本', max: 16000 },
        { name: '力率电费占比', max: 30000 },
        { name: '基础电费', max: 38000 },
        { name: '峰谷电费', max: 52000 },
      ],
    },
    series: [
      {
        type: 'radar',
        lineStyle: {
          color: '#ffffff',
          width: 2,
        },
        areaStyle: {
          color: 'rgba(46, 255, 220, 0.7)',
        },
        symbolSize: 8,
        itemStyle: {
          color: '#FC6C4F',
          borderColor: '#FC6C4F',
          borderWidth: 8,
        },
        areaStyle: {
          color: 'rgba(84, 232, 208, 0.7)',
        },
        data: [
          {
            value: [90, 10000, 28000, 35000, 50000],
            name: '用户用能画像',
          },
        ],
      },
    ],
  };
  return option;
};

const DownloadURL = 'https://report-1302976931.cos.ap-shanghai.myqcloud.com';

export default React.memo(function RealData(props) {
  const { customerInfo, stationId, point } = props;

  // const date = moment()
  //   .subtract(1, 'months')
  //   .format('YYYY-MM');
  const date =
    customerInfo.features.includes(featureEnum.bigData) &&
    customerInfo.reportDate;
  const url = `${DownloadURL}/${date}/${customerInfo.number}_${date}.pdf`;
  // const { data: list, loading: listLoading } = useRequest(
  //   () => services.getRealData(number, stationId, point),
  //   {
  //     formatResult(res) {
  //       return get(res, 'data.bean', null);
  //     },
  //     refreshDeps: [point, date],
  //     ready: point,
  //   },
  // );
  return (
    <Container loading={false}>
      <div>
        <div className="sub-title">用户用能画像</div>
        <div className="customer-radar">
          <ReactEchartsCore
            option={getOption()}
            echarts={echarts}
            notMerge={true}
            lazyUpdate={true}
            style={{ height: '365px' }}
          />
        </div>
        {date && (
          <div className="sub-title">
            <a
              target="_blank"
              href="https://epk.faladi.cn:31009/#/om/clientReport"
            >
              升级报告
            </a>
            <a className="link" target="_blank" href={url}>
              点击下载
            </a>
          </div>
        )}
      </div>
    </Container>
  );
});
