import React from 'react';
import { connect } from 'dva';
import { Progress } from 'antd';
import AntdModal from '../../components/AntdModal';
import Info from '../Customer/Info';
import styles from './index.less';
import imgPower from '../../../../resource/images/screen/check_power.png';
import imgLoad from '../../../../resource/images/screen/check_load.png';
import imgEleDay from '../../../../resource/images/screen/check_eleday.png';
import imgEleMonth from '../../../../resource/images/screen/check_elemonth.png';
import imgTan from '../../../../resource/images/screen/check_tan.png';
import imgTem from '../../../../resource/images/screen/check_tem.png';
import imgWet from '../../../../resource/images/screen/check_wet.png';
import imgMu from '../../../../resource/images/screen/check_mu.png';
import imgGuard1 from '../../../../resource/images/screen/check_guard1.png';
import imgGuard2 from '../../../../resource/images/screen/check_guard2.png';
import imgSmoke from '../../../../resource/images/screen/check_smoke.png';
import imgWater from '../../../../resource/images/screen/check_water.png';

export default connect(({ screen }) => ({
  checkInfo: screen.checkInfo
}))(React.memo(function CheckInfo({ dispatch, checkInfo }) {
  const onClose = () => dispatch({ type: 'screen/handleCheckInfo', payload: '' });

  const show = !!checkInfo;
  if (!show) {
    return null
  }

  return (
    <AntdModal className={styles.box} onClose={onClose} title="环境监测">
      {/* <div className={styles.infoRow}>
        <Info
          img={imgPower}
          label="当前总功率KW"
          value="23"
        />
        <Info
          img={imgLoad}
          label="当前总负荷率%"
          value="72"
        />
        <Info
          img={imgEleDay}
          label="日用电量kWh"
          value="18"
        />
        <Info
          img={imgEleMonth}
          label="月用电量kWh"
          value="18"
        />
      </div> */}
      <div className={styles.infoRow}>
        {/* <Info
          img={imgTan}
          label="碳排放kg"
          value="23"
        /> */}
        <Info
          img={imgTem}
          label="环境温度℃"
          value="18"
        />
        <Info
          img={imgWet}
          label="环境湿度%"
          value="72"
        />
      </div>
      <div className={styles.infoRow}>
        <Info
          img={imgMu}
          label="低压母排温度℃"
          value="23"
        />
        <Info
          img={imgGuard1}
          label="门禁1"
          value="正常"
          valueStyle={{fontSize: 22}}
        />
        <Info
          img={imgGuard2}
          label="门禁2"
          value="正常"
          valueStyle={{fontSize: 22}}
        />
        <Info
          img={imgSmoke}
          label="烟感"
          value="正常"
          valueStyle={{fontSize: 22}}
        />
        <Info
          img={imgWater}
          label="水浸"
          value="正常"
          valueStyle={{fontSize: 22}}
        />
      </div>
    </AntdModal>
  );
}))
