/**
 * 巡检数据
 */

import React from 'react';
import { connect } from 'dva';
import classNames from 'classnames';
import Trend from '../components/Trend';
import RadarCanvas from '../components/RadarCanvas';
import MonthSelect from '../components/MonthSelect';
import styles from './index.less';
import {LeftUrlMap} from '../constants';

import 'echarts/lib/chart/pie';

const InspectionData = ({num, title, month, theme = 'blue', onMonthChange, isNormal}) => {
  const className = classNames(
    styles.inspectionData,
    {
      [styles.inspectionDataBlue]: theme === 'blue',
      [styles.inspectionDataOrange]: theme !== 'blue'
    }
  );

  return (
    <div className={className}>
      <div className={styles.inspectionDataNum}><span>{parseInt(num * 100)+ '%'}</span></div>
      <div className={styles.inspectionDataTitle}>{title}</div>
      {/*<MonthSelect*/}
      {/*  value={month}*/}
      {/*  theme={theme}*/}
      {/*  direction="up"*/}
      {/*  onSelect={onMonthChange}*/}
      {/*  isNormal={isNormal}*/}
      {/*/>*/}
    </div>
  );
};
@connect(({ overview }) => ({ ...overview}))
export default class Inspection extends React.PureComponent {
  onMonthChange = (index) => {
    const {dispatch} = this.props;
    dispatch({
      type: 'overview/changeMonth',
      payload: index
    })
    dispatch({
      type: 'overview/onMonthChange',
      payload: index
    })
  }

  render() {
    const {month, inspectionData, isNormal} = this.props;
    const wrapClassNames = classNames(styles.inspection, {
      [styles.inspectionNormal]: isNormal
    })
    const chartSize = `${isNormal ? '295' : '170'}px`

    return <div className={wrapClassNames}>
        <div>
          <div className={styles.processWrap}
               onClick={() => window.open(LeftUrlMap.reach)}>
            <InspectionData
              num={inspectionData.reach}
              title="月巡检达成率"
              month={month}
              theme="blue"
              onMonthChange={this.onMonthChange}
              isNormal={isNormal}
            />
            <RadarCanvas
              theme="blue"
              canvasId="reach"
              width={chartSize}
              percent={inspectionData.reach}
              height={chartSize}
            />
          </div>
          <div className={styles.bottomTrend}>
            <Trend
              title="年同比"
              num={Math.abs(inspectionData.reach_year_on_year)}
              up={inspectionData.reach_year_on_year > 0}
              layout="row"
              hasBorder
              isNormal={isNormal}
            />
            <Trend
              title="月环比"
              num={inspectionData.reach_month_on_month}
              up={inspectionData.reach_month_on_month > 0}
              layout="row"
              hasBorder
              isNormal={isNormal}
            />
          </div>
        </div>
        <div>
          <div className={styles.processWrap}
               onClick={() => window.open(LeftUrlMap.exception)}>
            <InspectionData
              num={inspectionData.exception_handling}
              title="月异常处理率"
              month={month}
              theme="orange"
              onMonthChange={this.onMonthChange}
              isNormal={isNormal}
            />
            <RadarCanvas
              theme="orange"
              canvasId="exception"
              percent={inspectionData.exception_handling}
              width={chartSize}
              height={chartSize}
              theme="orange"
            />
          </div>
          <div className={styles.bottomTrend}>
            <Trend
              title="年同比"
              num={Math.abs(inspectionData.exception_year_on_year)}
              up={inspectionData.exception_year_on_year > 0}
              layout="row"
              hasBorder
              isNormal={isNormal}
            />
            <Trend
              title="月环比"
              num={inspectionData.exception_month_on_month}
              up={inspectionData.exception_month_on_month > 0}
              layout="row"
              hasBorder
              isNormal={isNormal}
            />
          </div>
        </div>
    </div>
  }
}

