import customer from './customer.json'
export default {
  '/api/map/district': wrapper([
    {
      position: [114.502461, 38.045474],
      type: 'vehicle',
      id: 6,
    },
    {
      position: [114.652461, 38.168474],
      type: 'customer',
      id: 21,
    },
    {
      position: [108.948024, 34.263161],
      type: 'people',
      id: 11,
    },
    {
      position: [117.283042, 31.86119],
      type: 'vehicle',
      id: 0,
    },
    {
      position: [117.285042, 31.86119],
      type: 'customer',
      id: 20,
    },
    {
      position: [108.283042, 31.46119],
      type: 'vehicle',
      id: 4,
    },
    {
      position: [114.283042, 38.86119],
      type: 'customer',
      id: 5,
    },
  ]),
  '/api/map/table': wrapper([{
    id: 1,
    number: '京A555555',
    status: 'normal',
  }, {
    id: 2,
    number: '京A555555',
    status: 'normal',
  }, {
    id: 3,
    number: '京A555555',
    status: 'error',
  }, {
    id: 4,
    number: '京A555555',
    status: 'normal',
  }]),
  '/api/v1/console/OMS/dashboard/cars': wrapper([{
    id: 1,
    number_plate: '京A555551',
    status: 0,
    name: 'normal',
    imei: 'xxx',
    longitude: 114.502461,
    latitude: 38.045474,
  }, {
    id: 2,
    number_plate: '京A555552',
    status: 1,
    name: 'normal',
    imei: 'xxx',
    longitude: 117.283042,
    latitude: 31.86119,
  }, {
    id: 3,
    number_plate: '京A555553',
    status: 10,
    name: 'normal',
    imei: 'xxx',
    longitude: 108.283042,
    latitude: 31.46119,
  }, {
    id: 4,
    number_plate: '京A555554',
    status: 20,
    name: 'normal',
    imei: 'xxx',
    longitude: 110.502461,
    latitude: 37.045474,
  }]),
  '/api/v1/console/OMS/dashboard/people': wrapper([{
    id: 12,
    name: '曹志国',
    group: '班组4',
    rate: 5,
    phone: '17667855667',
    status: 0,
    longitude: 121.565990,
    latitude: 31.215226,
  }, {
    id: 1,
    name: '胡烨磊',
    rate: 5,
    group: '班组1',
    phone: '18769635667',
    status: 0,
    longitude: 113.652461,
    latitude: 37.168474,
  }, {
    id: 2,
    name: '沈星津',
    rate: 3,
    group: '班组2',
    phone: '17967996667',
    status: 2,
    longitude: 122.652461,
    latitude: 29.168474,
  }, {
    id: 3,
    name: '廖高翰',
    rate: 4,
    group: '班组3',
    phone: '15667855690',
    status: 1,
    longitude: 123.652461,
    latitude: 39.168474,
  }, {
    id: 4,
    name: '熊和风',
    rate: 5,
    group: '班组4',
    phone: '17367855660',
    status: 0,
    longitude: 114.652461,
    latitude: 35.168474,
  }, {
    id: 5,
    name: '谢文宣',
    rate: 5,
    group: '班组5',
    phone: '13967055667',
    status: 0,
    longitude: 117.652461,
    latitude: 33.168474,
  }, {
    id: 6,
    name: '于向文',
    rate: 4,
    group: '班组3',
    phone: '17867855521',
    status: 0,
    longitude: 114.652461,
    latitude: 35.168474,
  }, {
    id: 7,
    name: '李安',
    rate: 5,
    group: '班组14',
    phone: '17967888767',
    status: 0,
    longitude: 113.652461,
    latitude: 36.168474,
  }, {
    id: 8,
    name: '易国源',
    group: '班组4',
    rate: 5,
    phone: '18767435667',
    status: 0,
    longitude: 114.952461,
    latitude: 33.168474,
  }, {
    id: 9,
    name: '曾开宇',
    group: '班组42',
    rate: 5,
    phone: '17967823667',
    status: 0,
    longitude: 115.952461,
    latitude: 32.168474,
  }, {
    id: 10,
    name: '梁翰墨',
    rate: 4,
    group: '班组4',
    phone: '15667853667',
    status: 0,
    longitude: 104.652461,
    latitude: 31.168474,
  }, {
    id: 11,
    name: '程飞翮',
    rate: 4,
    group: '班组4',
    phone: '17867853345',
    status: 0,
    longitude: 113.652461,
    latitude: 25.348474,
  }]),
  '/api/v1/console/OMS/dashboard/customers': customer || wrapper([{
    status: 'normal',
    name: 'normal',
    address: 'xxx',
    adcode: 4,
    longitude: 114.652461,
    latitude: 38.168474,
  }, {
    status: 'normal',
    name: 'normal',
    address: 'xxx',
    adcode: 3,
    longitude: 117.285042,
    latitude: 31.86119,
  }, {
    status: 'normal',
    name: 'normal',
    address: 'xxx',
    adcode: 1,
    longitude: 114.283042,
    latitude: 38.86119,
  }, {
    status: 'normal',
    name: 'normal',
    address: 'xxx',
    adcode: 8,
    longitude: 99.502461,
    latitude: 39.86119,
  }]),
  '/api/v1/console/OMS/equipment/list': wrapper([{
    id: 2,
    name: '进线柜1',
    type: '常规',
    vendor: '厂商1',
    model: 'M101',
    number: '1122',
    date: '20200810'
  }, {
    id: 4,
    name: '进线柜2',
    type: '常规',
    vendor: '厂商2',
    model: 'M103',
    number: '1122',
    date: '20200810'
  }, {
    id: 5,
    name: '进线柜3',
    type: '常规',
    vendor: '厂商3',
    model: 'M101',
    number: '1122',
    date: '20200810'
  }, {
    id: 8,
    name: '进线柜4',
    type: '常规',
    vendor: '厂商4',
    model: 'M104',
    number: '1122',
    date: '20200810'
  }]),
  '/api/v1/console/OMS/dashboard/numbers/1/details': ({
    "customer": {
      "number": {
        "id": 1,
        "number": "0000727272"
      },
      "id": 1,
      "code": "OA1-0000727272",
      "customer_name": "上海普天科创电子有限公司(上海普天科创物业管理有限公司)",
      "service_staff_id": 1,
      "service_staff_name": "admin",
      "stations": [
        {
          "name": "电站1",
          "id": 4,
          "addr": "上海普天科创电子有限公司",
          "city_code": "435",
          "ad_code": "3546",
          "operation_level": "2354",
          "status": 1,
          "videos": [
            "http://hls01open.ys7.com/openlive/cc9073571e0c471ca4224debb3ac5eca.m3u8"
          ],
          "drawing": [

          ],
          "power_curve": {

          }
        },
        {
          "name": "电站2",
          "id": 5,
          "addr": "上海普天科创电子有限公司",
          "city_code": "3245",
          "ad_code": "2345",
          "operation_level": "234356",
          "status": 1,
          "videos": [
            "http://hls01open.ys7.com/openlive/cc9073571e0c471ca4224debb3ac5eca.m3u8"
          ],
          "drawing": [

          ],
          "power_curve": {

          }
        }
      ],
      "teams": [
        {
          "id": 60,
          "name": "抢修专组",
          "type": "2"
        },
        {
          "id": 64,
          "name": "班组1452",
          "type": "0"
        }
      ],
      "electrical": {
        "used": 1850,
        "total": 2000,
        "rate": 0.925,
        "real_power": 0.72
      }
    }
  }),
  '/api/v1/console/OMS/dashboard/ele': wrapperObj({
    data1: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24],
    data2: [24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1]
  }),
  '/api/v1/console/OMS/dashboard/realData': ([
    {
      label: 'AB线电压',
      value: '17981.278 V'
    },
    {
      label: 'BC线电压',
      value: '0.000 V'
    },
    {
      label: 'CA线电压',
      value: '17882.207 V'
    },
    {
      label: 'A相电压',
      value: '10381.8 V'
    },
    {
      label: 'B相电压',
      value: '0 V'
    },
    {
      label: 'C相电压',
      value: '10324.6 V'
    },
    {
      label: 'A相电流',
      value: '0.675 A'
    },
    {
      label: 'B相电流',
      value: '0.608 A'
    },
    {
      label: 'C相电流',
      value: '0.6 A'
    },
    {
      label: 'A相有功功率',
      value: '3.705 kW'
    },
    {
      label: 'B相有功功率',
      value: '0 kW'
    },
    {
      label: 'C相有功功率',
      value: '5.07 kW'
    },
    {
      label: 'A相无功功率',
      value: '5.85 Kvar'
    },
    {
      label: 'B相无功功率',
      value: '0 Kvar'
    },
    {
      label: 'C相无功功率',
      value: '-3.51 Kvar'
    },
    {
      label: 'A相功率因数',
      value: '0.528'
    },
    {
      label: 'B相功率因数',
      value: '1'
    },
    {
      label: 'C相功率因数',
      value: '0.813'
    },
    {
      label: '总有功功率',
      value: '8.775 kW'
    },
    {
      label: '总无功功率',
      value: '2.34 Kvar'
    },
    {
      label: '总功率因数',
      value: '1'
    },
    {
      label: '总有功电度',
      value: '72504.2 kWh'
    },
    {
      label: '感性无功电度',
      value: '41608 kVarh'
    },
    {
      label: '容性无功电度',
      value: '2511.6 kVarh'
    },
    {
      label: '环境温度',
      value: '24.107 °C'
    },
    {
      label: '环境湿度',
      value: '46.76%'
    },
    {
      label: '温度（柜体）',
      value: '21.4 °C'
    },
    {
      label: '电网频率',
      value: '49.95 HZ'
    },
    {
      label: '有功需量',
      value: '8.19 kW'
    },
    {
      label: '数据时间',
      value: getDate()
    },
  ]),
  '/api/v1/console/OMS/dashboard/safeTool': ([
    {
      label: '高压验电笔',
      value: 3,
    },
    {
      label: '接地线',
      value: 3,
    },
    {
      label: '高压绝缘手套',
      value: 3,
    },
    {
      label: '绝缘笔',
      value: 3,
    },
    {
      label: '安全标识牌',
      value: 3,
    },
    {
      label: '应急照明灯',
      value: 3,
    },
    {
      label: '电气一次接线模拟屏',
      value: 3,
    },
    {
      label: '地上警示线',
      value: 3,
    },
    {
      label: '灭火器',
      value: 3,
    },
    {
      label: '其他',
      value: 3,
    },
  ]),
  '/api/v1/console/monitor/old/numbers/data': wrapperObj([
    { "id": 1620, "imei": "44003A19473832383636301F", "line": 0, "ua": 38.026, "ub": 68.297, "uc": 139.901, "ia": 293, "ib": 295.5, "ic": 220.5, "pa": 69, "pb": 69.5, "pc": 52.5, "psum": 191, "qa": -10.5, "qb": -9.5, "qc": -4.5, "qsum": -25, "pfa": 0.988, "pfb": 0.991, "pfc": 0.996, "pfsum": 0.992, "fr": 49.97, "px": 196.5, "eq1": 6642.9, "eq2": 41922.3, "ep": 593993, "tc": 19.7, "tc4": null, "tc3": null, "tc2": null, "tc1": null, "ich": null, "ibh": null, "iah": null, "uch": null, "ubh": null, "uah": null, "t": 14.21, "s": 55.82, "ht": 0, "ti": 2873, "net": 0, "tm": "2021-01-23T21:52:48", "comments": "南汇10发货单20200528001" },
    { "id": 1620, "imei": "44003A19473832383636301F", "line": 0, "ua": 23.026, "ub": 98.297, "uc": 69.901, "ia": 293, "ib": 295.5, "ic": 220.5, "pa": 69, "pb": 69.5, "pc": 52.5, "psum": 191, "qa": -10.5, "qb": -9.5, "qc": -4.5, "qsum": -25, "pfa": 0.988, "pfb": 0.991, "pfc": 0.996, "pfsum": 0.992, "fr": 49.97, "px": 196.5, "eq1": 6642.9, "eq2": 41922.3, "ep": 593993, "tc": 19.7, "tc4": null, "tc3": null, "tc2": null, "tc1": null, "ich": null, "ibh": null, "iah": null, "uch": null, "ubh": null, "uah": null, "t": 14.21, "s": 55.82, "ht": 0, "ti": 2873, "net": 0, "tm": "2021-01-23T21:52:48", "comments": "南汇10发货单20200528001" },
    { "id": 1620, "imei": "44003A19473832383636301F", "line": 0, "ua": 238.026, "ub": 90.297, "uc": 96.901, "ia": 293, "ib": 295.5, "ic": 220.5, "pa": 69, "pb": 69.5, "pc": 52.5, "psum": 191, "qa": -10.5, "qb": -9.5, "qc": -4.5, "qsum": -25, "pfa": 0.988, "pfb": 0.991, "pfc": 0.996, "pfsum": 0.992, "fr": 49.97, "px": 196.5, "eq1": 6642.9, "eq2": 41922.3, "ep": 593993, "tc": 19.7, "tc4": null, "tc3": null, "tc2": null, "tc1": null, "ich": null, "ibh": null, "iah": null, "uch": null, "ubh": null, "uah": null, "t": 14.21, "s": 55.82, "ht": 0, "ti": 2873, "net": 0, "tm": "2021-01-23T21:52:48", "comments": "南汇10发货单20200528001" },
  ])
};

function wrapper(data) {
  return {
    code: 0,
    msg: 'ok',
    msg_show: 'ok',
    data: {
      list: data,
      page: 1,
      page_size: 10,
      count: data && data.length
    },
  }
}

function wrapperObj(data) {
  return {
    code: 0,
    msg: 'ok',
    msg_show: 'ok',
    data: {
      bean: data,
    },
  }
}

function getDate() {
  const now = new Date();
  return `${now.getFullYear()}-${now.getMonth() + 1}-${now.getDate()} ${now.getHours()}:${now.getMinutes()}:${now.getSeconds()}`
}
