import { defineConfig } from 'umi';
import path from 'path'

export default defineConfig({
  nodeModulesTransform: {
    type: 'none',
  },
  mock: false,
  locale: {
    default: 'zh-CN'
  },
  antd: {
    dark: true,
  },
  alias: {
    '@': path.resolve(__dirname, 'src'),
  },
  theme: require('./src/theme.js'),
  chainWebpack(config) {
    config.module.rule('file-loader')
      .test(/.mp4$/)
      .use('file-loader')
      .loader('file-loader')
  },
  routes: [
    { path: '/login', component: '@/pages/login' },
    { path: '/screen', component: '@/pages/screen' },
    { path: '/normal_screen', component: '@/pages/screen/normalScreen' }
  ],
  proxy: {
    '/api': {
      // target: 'http://epk.faladi.cn:31008',
      target: 'http://188.131.235.243:31002',
      changeOrigin: true
    },
    '/live_jia_personal': {
      target: 'http://flv-live.jia.360.cn',
      changeOrigin: true
    },
    '/live': {
      target: 'http://139.196.168.11:23505',
      changeOrigin: true
    }
  }
});
