from kafka import KafkaConsumer
from etl.settings import KAFKA


class BaseKafkaClient(object):
    def __init__(self, topic="epk_etl"):
        self.topic = topic
        self.group_id = KAFKA.get('default_group_id')
        self.auto_offset_reset = KAFKA.get('auto_offset_reset')
        self.auto_commit_interval_ms = KAFKA.get('auto_commit_interval_ms')
        self.enable_auto_commit = KAFKA.get('enable_auto_commit')
        self.bootstrap_servers = KAFKA.get('bootstrap_servers')
        self.client = None

    def create_customer(self, group_id):
        return KafkaConsumer(self.topic,
                             group_id=group_id,
                             auto_offset_reset=self.auto_offset_reset,
                             bootstrap_servers=self.bootstrap_servers,
                             enable_auto_commit=self.enable_auto_commit)


kafka_client = BaseKafkaClient()
