# coding=utf-8
import os
import sys
import copy
import json
import shutil
etl_base = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.append(etl_base)
from etl.settings import DATABASE
from etl.original_database.jobs_config import jobs, trans_jobs
datax_config_path = os.path.dirname(os.path.abspath(__file__))

db = {
    "reader": {
        "jdbcUrl": [
            "jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                DATABASE.ORIGINAL_MYSQL_HOST,
                DATABASE.ORIGINAL_MYSQL_PORT,
                DATABASE.ORIGINAL_MYSQL_DB,
            )
        ],
        "username": DATABASE.ORIGINAL_MYSQL_USER,
        "password": DATABASE.ORIGINAL_MYSQL_PASS,
    },
    "writer": {
        "jdbcUrl": [
            "jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                DATABASE.SLAVE_MYSQL_HOST,
                DATABASE.SLAVE_MYSQL_PORT,
                DATABASE.SLAVE_MYSQL_DB,
            )
        ],
        "username": DATABASE.SLAVE_MYSQL_USER,
        "password": DATABASE.SLAVE_MYSQL_PASS,
    },
}
base_json = {
    "job": {
        "content": [{
            "reader": {
                "name": "mysqlreader",
                "parameter": {
                    "username": DATABASE.ORIGINAL_MYSQL_USER,
                    "password": DATABASE.ORIGINAL_MYSQL_PASS,
                    "column": [],
                    "sliceRecordCount":
                    "",
                    "connection": [{
                        "jdbcUrl": [
                            "jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                                DATABASE.ORIGINAL_MYSQL_HOST,
                                DATABASE.ORIGINAL_MYSQL_PORT,
                                DATABASE.ORIGINAL_MYSQL_DB,
                            )
                        ],
                        "table": [],
                    }]
                }
            },
            "writer": {
                "name": "mysqlwriter",
                "parameter": {
                    "writeMode": "update",
                    "username": DATABASE.SLAVE_MYSQL_USER,
                    "password": DATABASE.SLAVE_MYSQL_PASS,
                    "column": [],
                    "preSql": [],
                    "connection": [{
                        "jdbcUrl":"jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                            DATABASE.SLAVE_MYSQL_HOST,
                            DATABASE.SLAVE_MYSQL_PORT,
                            DATABASE.SLAVE_MYSQL_DB
                        ),
                        "table": [],
                    }]
                }
            }
        }],
        "setting": {
            "speed": {
                "channel": 3
            },
            "errorLimit": {
                "record": 10000,
                "percentage": 1.0
            }
        }
    }
}

trans_db = {
    "reader": {
        "jdbcUrl": [
            "jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                DATABASE.ORIGINAL_MYSQL_HOST,
                DATABASE.ORIGINAL_MYSQL_PORT,
                DATABASE.ORIGINAL_MYSQL_DB,
            )
        ],
        "username": DATABASE.ORIGINAL_MYSQL_USER,
        "password": DATABASE.ORIGINAL_MYSQL_PASS,
    },
    "writer": {
        "jdbcUrl": [
            "jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                DATABASE.TRANSFORMATION_MYSQL_HOST,
                DATABASE.TRANSFORMATION_MYSQL_PORT,
                DATABASE.TRANSFORMATION_MYSQL_DB,
            )
        ],
        "username": DATABASE.TRANSFORMATION_MYSQL_USER,
        "password": DATABASE.TRANSFORMATION_MYSQL_PASS,
    },
}

trans_base_json = {
    "job": {
        "content": [{
            "reader": {
                "name": "mysqlreader",
                "parameter": {
                    "username": DATABASE.ORIGINAL_MYSQL_USER,
                    "password": DATABASE.ORIGINAL_MYSQL_PASS,
                    "sliceRecordCount":
                        "",
                    "connection": [{
                        "jdbcUrl": [
                            "jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                                DATABASE.ORIGINAL_MYSQL_HOST,
                                DATABASE.ORIGINAL_MYSQL_PORT,
                                DATABASE.ORIGINAL_MYSQL_DB,
                            )
                        ],
                        "querySql": []
                    }]
                }
            },
            "writer": {
                "name": "mysqlwriter",
                "parameter": {
                    "writeMode":
                        "update",
                    "username": DATABASE.TRANSFORMATION_MYSQL_USER,
                    "password": DATABASE.TRANSFORMATION_MYSQL_PASS,
                    "column": [],
                    "preSql": [],
                    "connection": [{
                        "jdbcUrl":"jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf-8".format(
                            DATABASE.TRANSFORMATION_MYSQL_HOST,
                            DATABASE.TRANSFORMATION_MYSQL_PORT,
                            DATABASE.TRANSFORMATION_MYSQL_DB
                        ),
                        "table": [],
                    }]
                }
            }
        }],
        "setting": {
            "speed": {
                "channel": 3
            },
            "errorLimit": {
                "record": 10000,
                "percentage": 1.0
            }
        }
    }
}


def del_file(filepath):
    """
    :param filepath
    :return:
    """
    del_list = os.listdir(filepath)
    for f in del_list:
        file_path = os.path.join(filepath, f)
        if os.path.isfile(file_path):
            os.remove(file_path)
        elif os.path.isdir(file_path):
            pass
            # shutil.rmtree(file_path)


def init_jobs_config():
    config_path = "{}/datax_job".format(datax_config_path)
    if not os.path.exists(config_path):
        os.makedirs(config_path)
    del_file(config_path)
    for job in jobs:
        table = job
        value = jobs[job]
        json_format = copy.deepcopy(base_json)
        json_format["job"]["content"][0]["reader"]["parameter"][
            "column"] = value
        json_format["job"]["content"][0]["reader"]["parameter"]["connection"][
            0]["table"].append(table)
        json_format["job"]["content"][0]["writer"]["parameter"][
            "column"] = value
        json_format["job"]["content"][0]["writer"]["parameter"]["connection"][
            0]["table"].append(table)
        json_format["job"]["content"][0]["writer"]["parameter"][
            "preSql"].append("delete from {}".format(table))
        with open('{}/{}.json'.format(config_path, table), 'w') as f:
            json.dump(json_format, f)


def init_trans_jobs_config():
    config_path = "{}/datax_job/trans_jobs/".format(datax_config_path)
    if not os.path.exists(config_path):
        os.makedirs(config_path)
    del_file(config_path)
    for job in trans_jobs:
        table = job
        value = trans_jobs[job]
        json_format = copy.deepcopy(trans_base_json)
        json_format["job"]["content"][0]["reader"]["parameter"][
            "connection"][0]["querySql"] = value["query_sql"]
        json_format["job"]["content"][0]["writer"]["parameter"][
            "column"] = value["column"]
        json_format["job"]["content"][0]["writer"]["parameter"]["connection"][
            0]["table"].append(table)
        # json_format["job"]["content"][0]["writer"]["parameter"][
        #     "preSql"].append("delete from {}".format(table))
        with open('{}/{}.json'.format(config_path, table), 'w') as f:
            json.dump(json_format, f)


init_jobs_config()
init_trans_jobs_config()
