SET NAMES utf8mb4;


CREATE TABLE `accounts`
(
    `id`                   int(11)                                 NOT NULL AUTO_INCREMENT,
    `password`             varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `last_login`           datetime(6)                             DEFAULT NULL,
    `is_superuser`         tinyint(1)                              NOT NULL,
    `username`             varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
    `first_name`           varchar(30) COLLATE utf8mb4_unicode_ci  NOT NULL,
    `last_name`            varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
    `email`                varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
    `is_staff`             tinyint(1)                              NOT NULL,
    `is_active`            tinyint(1)                              NOT NULL,
    `date_joined`          datetime(6)                             NOT NULL,
    `update_time`          datetime(6)                             NOT NULL,
    `create_time`          datetime(6)                             NOT NULL,
    `certification_status` tinyint(1)                              NOT NULL,
    `account_type`         varchar(32) COLLATE utf8mb4_unicode_ci  NOT NULL,
    `head_img`             varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `username` (`username`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `accounts_groups`
(
    `id`          int(11) NOT NULL AUTO_INCREMENT,
    `accounts_id` int(11) NOT NULL,
    `group_id`    int(11) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `accounts_groups_accounts_id_group_id_5dce653d_uniq` (`accounts_id`, `group_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `accounts_user_permissions`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `accounts_id`   int(11) NOT NULL,
    `permission_id` int(11) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `accounts_user_permission_accounts_id_permission_i_4ac2438e_uniq` (`accounts_id`, `permission_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `auth_group`
(
    `id`   int(11)                                 NOT NULL AUTO_INCREMENT,
    `name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `name` (`name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `auth_group_permissions`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `group_id`      int(11) NOT NULL,
    `permission_id` int(11) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `auth_group_permissions_group_id_permission_id_0cd325b0_uniq` (`group_id`, `permission_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `auth_permission`
(
    `id`              int(11)                                 NOT NULL AUTO_INCREMENT,
    `name`            varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `content_type_id` int(11)                                 NOT NULL,
    `codename`        varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `auth_permission_content_type_id_codename_01ab375a_uniq` (`content_type_id`, `codename`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `consumable_material`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `order_id`      int(11)    DEFAULT NULL,
    `material_id`   int(11)    DEFAULT NULL,
    `number`        int(11)    DEFAULT '0',
    `deleted`       tinyint(1) DEFAULT '0',
    `created_time`  datetime   DEFAULT NULL,
    `updated_time`  datetime   DEFAULT NULL,
    `deleted_time`  datetime   DEFAULT NULL,
    `self_provided` tinyint(1) DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `contact`
(
    `id`           int(11) unsigned NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(4)                DEFAULT '0',
    `created_time` datetime                  DEFAULT NULL,
    `updated_time` datetime                  DEFAULT NULL,
    `deleted_time` datetime                  DEFAULT NULL,
    `name`         varchar(64)      NOT NULL DEFAULT '',
    `customer_id`  int(11)                   DEFAULT NULL,
    `phone`        varchar(16)               DEFAULT NULL,
    `tel`          varchar(64)               DEFAULT NULL,
    `email`        varchar(128)              DEFAULT NULL,
    `qq`           varchar(32)               DEFAULT NULL,
    `wechat`       varchar(64)               DEFAULT NULL,
    `is_urge`      tinyint(4)                DEFAULT '0',
    `is_quit`      tinyint(4)                DEFAULT '0',
    `comments`     varchar(1024)             DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `customer_id` (`customer_id`),
    KEY `deleted` (`deleted`),
    KEY `created_time` (`created_time`),
    KEY `is_quit` (`is_quit`),
    KEY `is_urge` (`is_urge`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `contact_tags`
(
    `id`           int(11) unsigned NOT NULL AUTO_INCREMENT,
    `contact_id`   int(11)    DEFAULT NULL,
    `tag_id`       int(11)    DEFAULT NULL,
    `deleted`      tinyint(4) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `tag_id` (`tag_id`),
    KEY `contact_id` (`contact_id`),
    KEY `created_time` (`created_time`),
    KEY `deleted` (`deleted`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `contract`
(
    `id`                  int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`             tinyint(1) unsigned zerofill           NOT NULL DEFAULT '0',
    `created_time`        datetime(6)                                     DEFAULT NULL,
    `updated_time`        datetime(6)                                     DEFAULT NULL,
    `deleted_time`        datetime(6)                                     DEFAULT NULL,
    `child_id`            int(11)                                         DEFAULT NULL,
    `code`                varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
    `amount`              decimal(12, 4)                                  DEFAULT NULL,
    `payed_price`         decimal(12, 4)                         NOT NULL,
    `entry_date`          date                                            DEFAULT NULL,
    `effective_date`      date                                            DEFAULT NULL,
    `end_date`            date                                            DEFAULT NULL,
    `closed_date`         date                                            DEFAULT NULL,
    `remark`              varchar(1024) COLLATE utf8mb4_unicode_ci        DEFAULT '',
    `business_entity_id`  int(11)                                         DEFAULT NULL,
    `contract_party_id`   int(11)                                         DEFAULT NULL,
    `customer_id`         int(11)                                         DEFAULT NULL,
    `customer_contact_id` int(11)                                         DEFAULT NULL,
    `salesman_id`         int(11)                                         DEFAULT NULL,
    `type`                int(11)                                         DEFAULT NULL,
    `organization_id`     int(11)                                         DEFAULT NULL,
    `liquidated_damages`  decimal(5, 2)                                   DEFAULT '0.00',
    `billing_period`      int(11)                                         DEFAULT '0',
    `offer_id`            int(11)                                         DEFAULT NULL,
    `offer_sn`            varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `sub_type`            tinyint(4)                                      DEFAULT NULL,
    `support_id`          int(11)                                         DEFAULT '0',
    PRIMARY KEY (`id`),
    KEY `child_id` (`child_id`),
    KEY `business_entity_id` (`business_entity_id`),
    KEY `contract_party_id` (`contract_party_id`),
    KEY `customer_id` (`customer_id`),
    KEY `customer_contact_id` (`customer_contact_id`),
    KEY `salesman_id` (`salesman_id`),
    KEY `type` (`type`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `customer`
(
    `id`                      int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`                 tinyint(1)                             NOT NULL DEFAULT '0',
    `created_time`            datetime(6)                                     DEFAULT NULL,
    `updated_time`            datetime(6)                                     DEFAULT NULL,
    `deleted_time`            datetime(6)                                     DEFAULT NULL,
    `name`                    varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `level`                   varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `type`                    varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
    `code`                    varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `enterprise_id`           int(11)                                         DEFAULT NULL,
    `last_service_staff_id`   int(11)                                         DEFAULT NULL,
    `service_staff_id`        int(11)                                         DEFAULT NULL,
    `service_enterprise_id`   int(11)                                         DEFAULT NULL,
    `service_organization_id` int(11)                                         DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `service_enterprise_id` (`service_enterprise_id`),
    KEY `service_organization_id` (`service_organization_id`),
    KEY `enterprise_id` (`enterprise_id`),
    KEY `service_staff_id` (`service_staff_id`),
    KEY `last_service_staff_id` (`last_service_staff_id`),
    KEY `type` (`type`),
    KEY `deleted` (`deleted`),
    FULLTEXT KEY `name` (`name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `customer_admin`
(
    `id`           int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1) NOT NULL DEFAULT '0',
    `created_time` datetime(6)         DEFAULT NULL,
    `updated_time` datetime(6)         DEFAULT NULL,
    `deleted_time` datetime(6)         DEFAULT NULL,
    `user_id`      int(11)             DEFAULT NULL,
    `customer_id`  int(11)             DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `customer_id` (`customer_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `defect`
(
    `id`              int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`         tinyint(1) NOT NULL,
    `created_time`    datetime(6)                             DEFAULT NULL,
    `updated_time`    datetime(6)                             DEFAULT NULL,
    `deleted_time`    datetime(6)                             DEFAULT NULL,
    `status`          varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `name`            varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `content`         varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `proposal`        longtext COLLATE utf8mb4_unicode_ci,
    `level`           varchar(16) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `possible_result` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `file`            longtext COLLATE utf8mb4_unicode_ci,
    `follow_up`       longtext COLLATE utf8mb4_unicode_ci,
    `remark`          longtext COLLATE utf8mb4_unicode_ci,
    `type`            varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `customer_id`     int(11)                                 DEFAULT NULL,
    `spect_task_id`   int(11)                                 DEFAULT NULL,
    `station_id`      int(11)                                 DEFAULT NULL,
    `team_id`         int(11)                                 DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `dictionary`
(
    `id`           int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)                             NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `name`         varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `value`        longtext COLLATE utf8mb4_unicode_ci    NOT NULL,
    `model`        varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `remarks`      longtext COLLATE utf8mb4_unicode_ci,
    `equipment_id` int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `django_admin_log`
(
    `id`              int(11)                                 NOT NULL AUTO_INCREMENT,
    `action_time`     datetime(6)                             NOT NULL,
    `object_id`       longtext COLLATE utf8mb4_unicode_ci,
    `object_repr`     varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
    `action_flag`     smallint(5) unsigned                    NOT NULL,
    `change_message`  longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `content_type_id` int(11) DEFAULT NULL,
    `user_id`         int(11)                                 NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `django_content_type`
(
    `id`        int(11)                                 NOT NULL AUTO_INCREMENT,
    `app_label` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    `model`     varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `django_content_type_app_label_model_76bd3d3b_uniq` (`app_label`, `model`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `django_migrations`
(
    `id`      int(11)                                 NOT NULL AUTO_INCREMENT,
    `app`     varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `name`    varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
    `applied` datetime(6)                             NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `django_session`
(
    `session_key`  varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
    `session_data` longtext COLLATE utf8mb4_unicode_ci    NOT NULL,
    `expire_date`  datetime(6)                            NOT NULL,
    PRIMARY KEY (`session_key`),
    KEY `django_session_expire_date_a5c62663` (`expire_date`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `drafts`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `user_id`      int(11)     DEFAULT NULL,
    `title`        varchar(32) DEFAULT NULL,
    `index`        varchar(32) DEFAULT NULL,
    `content`      text,
    `deleted`      tinyint(1)  DEFAULT '0',
    `created_time` datetime    DEFAULT NULL,
    `updated_time` datetime    DEFAULT NULL,
    `deleted_time` datetime    DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `electrical_info`
(
    `id`                   int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`              tinyint(1)                             NOT NULL,
    `created_time`         datetime(6)                                     DEFAULT NULL,
    `updated_time`         datetime(6)                                     DEFAULT NULL,
    `deleted_time`         datetime(6)                                     DEFAULT NULL,
    `power_number`         varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `meter_number`         varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
    `incoming_line_name`   varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `comment`              longtext COLLATE utf8mb4_unicode_ci,
    `powerstation_id`      int(11)                                         DEFAULT NULL,
    `magnification`        float                                           DEFAULT '0',
    `transformer_capacity` float                                           DEFAULT '0',
    `real_capacity`        float                                           DEFAULT '0',
    `outline_number`       int(11)                                         DEFAULT '0',
    `electricity_user_id`  int(11)                                         DEFAULT NULL,
    `customer_id`          int(11)                                         DEFAULT NULL,
    `voltage_level`        varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `ep_factor`            varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `powerstation_id` (`powerstation_id`),
    KEY `electricity_user_id` (`electricity_user_id`),
    KEY `customer_id` (`customer_id`),
    KEY `power_number` (`power_number`),
    KEY `meter_number` (`meter_number`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `electricity_bill`
(
    `id`                  int(11)        NOT NULL AUTO_INCREMENT,
    `electrical_id`       int(11)                 DEFAULT NULL COMMENT '电气信息id',
    `year_month`          char(7)                 DEFAULT NULL COMMENT '账单年月:2017-07',
    `peak_volume`         int(11)                 DEFAULT NULL COMMENT '峰电量',
    `peak_volume2`        int(11)        NOT NULL DEFAULT '0' COMMENT '峰电量2',
    `tip_volume`          int(11)        NOT NULL COMMENT '尖电量',
    `tip_volume2`         int(11)        NOT NULL DEFAULT '0' COMMENT '尖电量2',
    `usual_volume`        int(11)                 DEFAULT NULL COMMENT '平电量',
    `usual_volume2`       int(11)        NOT NULL DEFAULT '0' COMMENT '平电量2',
    `valley_volume`       int(11)                 DEFAULT NULL COMMENT '谷电量',
    `valley_volume2`      int(11)        NOT NULL DEFAULT '0' COMMENT '谷电量2',
    `other_volume`        int(11)                 DEFAULT NULL COMMENT '其它电量',
    `peak_price`          decimal(6, 5)           DEFAULT NULL COMMENT '峰电价',
    `peak_price2`         decimal(6, 5)  NOT NULL DEFAULT '0.00000' COMMENT '峰电价2',
    `tip_price`           decimal(6, 5)  NOT NULL COMMENT '尖电价',
    `tip_price2`          decimal(6, 5)  NOT NULL DEFAULT '0.00000' COMMENT '尖电价2',
    `usual_price`         decimal(6, 5)           DEFAULT NULL COMMENT '平电价',
    `usual_price2`        decimal(6, 5)  NOT NULL DEFAULT '0.00000' COMMENT '平电价2',
    `valley_price`        decimal(6, 5)           DEFAULT NULL COMMENT '谷电价',
    `valley_price2`       decimal(6, 5)  NOT NULL DEFAULT '0.00000' COMMENT '谷电价2',
    `other_price`         decimal(6, 5)           DEFAULT NULL COMMENT '其它电价',
    `levy_fee`            decimal(10, 2)          DEFAULT NULL COMMENT '代征费用',
    `power_factor`        decimal(3, 2)           DEFAULT NULL COMMENT '功率因数考核值',
    `power_factor_real`   decimal(3, 2)           DEFAULT NULL COMMENT '功率因数实际值',
    `power_factor_adjust` decimal(4, 2)           DEFAULT NULL COMMENT '基本电价3容量',
    `report_md`           decimal(10, 2)          DEFAULT NULL COMMENT '基本电价1用电量(申报MD)',
    `max_md`              int(11)                 DEFAULT NULL COMMENT '实际最大MD',
    `basic_price`         decimal(8, 5)           DEFAULT NULL COMMENT '基本电价(1)',
    `capacity`            int(11)                 DEFAULT NULL COMMENT '总容量',
    `idle_volume`         int(11)                 DEFAULT NULL COMMENT '无功电量',
    `amount`              decimal(12, 2)          DEFAULT NULL COMMENT '总金额',
    `amount_adjust`       decimal(10, 2) NOT NULL COMMENT '力率调整',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `electrical_id` (`electrical_id`) USING BTREE,
    KEY `year_month` (`year_month`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  ROW_FORMAT = DYNAMIC;


CREATE TABLE `electricity_user`
(
    `id`                   int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`              tinyint(1)                             NOT NULL DEFAULT '0',
    `created_time`         datetime(6)                                     DEFAULT NULL,
    `updated_time`         datetime(6)                                     DEFAULT NULL,
    `deleted_time`         datetime(6)                                     DEFAULT NULL,
    `number`               varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
    `ad_code`              varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `city_code`            varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `addr`                 varchar(256) COLLATE utf8mb4_unicode_ci         DEFAULT NULL,
    `transformer_capacity` double                                          DEFAULT '0',
    `real_capacity`        double                                          DEFAULT '0',
    `voltage_level`        varchar(256) COLLATE utf8mb4_unicode_ci         DEFAULT NULL,
    `ep_factor`            double                                          DEFAULT '0',
    `type`                 varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `trusteeship_num`      double                                          DEFAULT '0',
    `longitude`            varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `latitude`             varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `householder`          varchar(64) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `phone`                varchar(16) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `customer_id`          int(11)                                         DEFAULT NULL,
    `billing_method`       varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `postcode`             varchar(32) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `is_md`                tinyint(4)                                      DEFAULT NULL,
    `report_contact_id`    int(11)                                         DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `customer_id` (`customer_id`),
    KEY `number` (`number`),
    KEY `report_contact_id` (`report_contact_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `enterprise`
(
    `id`                   int(11)     NOT NULL AUTO_INCREMENT,
    `deleted`              tinyint(1)  NOT NULL                     DEFAULT '0',
    `created_time`         datetime(6)                              DEFAULT NULL,
    `updated_time`         datetime(6)                              DEFAULT NULL,
    `deleted_time`         datetime(6)                              DEFAULT NULL,
    `enterprise_id`        varchar(32) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `name`                 varchar(64) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `logo`                 varchar(255) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `address`              varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `adcode`               varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `city_code`            varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `district`             varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `longitude`            decimal(10, 6)                           DEFAULT '0.000000',
    `latitude`             decimal(10, 6)                           DEFAULT '0.000000',
    `unit_type`            smallint(6) NOT NULL                     DEFAULT '0',
    `level`                smallint(6) NOT NULL                     DEFAULT '0',
    `legal_person`         varchar(32) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `legal_person_phone`   varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `tax_num`              varchar(64) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `bank_account_name`    varchar(255) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `bank_name`            varchar(255) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `postcode`             varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `scale`                int(11)                                  DEFAULT NULL,
    `nature`               smallint(6)                              DEFAULT NULL,
    `industry`             int(11)                                  DEFAULT NULL,
    `asset`                int(11)                                  DEFAULT NULL,
    `covered_area`         int(11)                                  DEFAULT NULL,
    `is_subsidiary`        tinyint(1)  NOT NULL                     DEFAULT '0',
    `parent_enterprise_id` int(11)                                  DEFAULT NULL,
    `is_admin`             tinyint(1)  NOT NULL                     DEFAULT '1',
    `admin_id`             int(11)                                  DEFAULT NULL,
    `file`                 varchar(255) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `enterprise_id` (`enterprise_id`),
    KEY `parent_enterprise_id` (`parent_enterprise_id`),
    KEY `admin_id` (`admin_id`),
    FULLTEXT KEY `address` (`address`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `equipment`
(
    `id`                   int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`              tinyint(1) NOT NULL,
    `created_time`         datetime(6)                             DEFAULT NULL,
    `updated_time`         datetime(6)                             DEFAULT NULL,
    `deleted_time`         datetime(6)                             DEFAULT NULL,
    `name`                 varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `type`                 varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `factory`              varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `model`                varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `price`                decimal(10, 4)                          DEFAULT NULL,
    `code`                 varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `voltage`              double     NOT NULL,
    `electricity`          double     NOT NULL,
    `production_code`      varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `production_date`      date                                    DEFAULT NULL,
    `operation_date`       date                                    DEFAULT NULL,
    `status`               tinyint(1)                              DEFAULT NULL,
    `parent_id`            int(11)                                 DEFAULT NULL,
    `transformer_capacity` int(11)                                 DEFAULT NULL,
    `file`                 varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `line_type`            varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `station_id`           int(11)                                 DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `form`
(
    `id`           int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)                             NOT NULL,
    `created_time` datetime(6)                            DEFAULT NULL,
    `updated_time` datetime(6)                            DEFAULT NULL,
    `deleted_time` datetime(6)                            DEFAULT NULL,
    `table`        varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `name`         varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `table` (`table`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `form_attribute`
(
    `id`           int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)                             NOT NULL,
    `created_time` datetime(6)                            DEFAULT NULL,
    `updated_time` datetime(6)                            DEFAULT NULL,
    `deleted_time` datetime(6)                            DEFAULT NULL,
    `attribute`    varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `data_type`    varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `explain`      varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `form_id`      int(11)                                DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `hand_over_record`
(
    `deleted`           tinyint(1)  NOT NULL,
    `created_time`      datetime(6)  DEFAULT NULL,
    `updated_time`      datetime(6)  DEFAULT NULL,
    `deleted_time`      datetime(6)  DEFAULT NULL,
    `id`                int(11)     NOT NULL AUTO_INCREMENT,
    `handover_time`     datetime(6) NOT NULL,
    `type`              varchar(16) NOT NULL,
    `inspect`           longtext,
    `changes`           varchar(256) DEFAULT NULL,
    `overhaul`          varchar(256) DEFAULT NULL,
    `work_situation`    varchar(32)  DEFAULT NULL,
    `equipment_inspect` varchar(256) DEFAULT NULL,
    `station_work`      varchar(256) DEFAULT NULL,
    `work_ticket`       varchar(32)  DEFAULT NULL,
    `handover_work`     varchar(256) DEFAULT NULL,
    `tool_check`        varchar(32)  DEFAULT NULL,
    `other`             longtext,
    `dispatch_options`  varchar(64)  DEFAULT NULL,
    `recieve_team_id`   int(11)      DEFAULT NULL,
    `station`           varchar(32)  DEFAULT NULL,
    `transfer_team_id`  int(11)      DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `init_db_log`
(
    `id`        int(11)     NOT NULL AUTO_INCREMENT,
    `name`      varchar(32) NOT NULL,
    `sql_num`   int(11)     NOT NULL,
    `error_msg` varchar(512) DEFAULT NULL,
    `run_time`  datetime(6)  DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `inspection_data`
(
    `id`                 int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`            tinyint(1) NOT NULL,
    `created_time`       datetime(6)   DEFAULT NULL,
    `updated_time`       datetime(6)   DEFAULT NULL,
    `deleted_time`       datetime(6)   DEFAULT NULL,
    `temperature`        double        DEFAULT NULL,
    `humidity`           double        DEFAULT NULL,
    `weather`            varchar(32)   DEFAULT NULL,
    `remarks`            longtext,
    `inspection_task_id` int(11)       DEFAULT NULL,
    `station_id`         int(11)       DEFAULT NULL,
    `team_id`            int(11)       DEFAULT NULL,
    `file`               text,
    `battery_voltage`    float         DEFAULT NULL,
    `direct_voltage`     float         DEFAULT NULL,
    `thermal_number`     varchar(1024) DEFAULT NULL,
    `inspector`          varchar(64)   DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    KEY `inspection_task_id` (`inspection_task_id`) USING BTREE,
    KEY `station_id` (`station_id`) USING BTREE,
    KEY `team_id` (`team_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `inspection_in`
(
    `id`              int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`         tinyint(1) NOT NULL,
    `created_time`    datetime(6) DEFAULT NULL,
    `updated_time`    datetime(6) DEFAULT NULL,
    `deleted_time`    datetime(6) DEFAULT NULL,
    `v_ab`            varchar(16) DEFAULT NULL,
    `v_bc`            varchar(16) DEFAULT NULL,
    `v_ca`            varchar(16) DEFAULT NULL,
    `monitor_a`       varchar(16) DEFAULT NULL,
    `monitor_b`       varchar(16) DEFAULT NULL,
    `monitor_c`       varchar(16) DEFAULT NULL,
    `inspect_task_id` int(11)     DEFAULT NULL,
    `power_number`    varchar(32) DEFAULT NULL,
    `i_a`             varchar(16) DEFAULT NULL,
    `i_b`             varchar(16) DEFAULT NULL,
    `i_c`             varchar(16) DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    KEY `inspect_task_id` (`inspect_task_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `inspection_out`
(
    `id`              int(11)     NOT NULL AUTO_INCREMENT,
    `deleted`         tinyint(1)  NOT NULL,
    `created_time`    datetime(6) DEFAULT NULL,
    `updated_time`    datetime(6) DEFAULT NULL,
    `deleted_time`    datetime(6) DEFAULT NULL,
    `o_ia`            varchar(16) DEFAULT NULL,
    `o_ib`            varchar(16) DEFAULT NULL,
    `o_ic`            varchar(16) DEFAULT NULL,
    `monitor_a`       varchar(32) DEFAULT NULL,
    `monitor_b`       varchar(32) DEFAULT NULL,
    `monitor_c`       varchar(32) DEFAULT NULL,
    `voice`           varchar(32) DEFAULT NULL,
    `fan`             varchar(32) DEFAULT NULL,
    `temperature`     varchar(64) DEFAULT NULL,
    `oil_leak`        varchar(32) DEFAULT NULL,
    `dry`             varchar(32) DEFAULT NULL,
    `abnormal`        varchar(32) DEFAULT NULL,
    `switch_v_ab`     varchar(16) DEFAULT NULL,
    `switch_v_bc`     varchar(16) DEFAULT NULL,
    `switch_ia`       varchar(16) DEFAULT NULL,
    `switch_ib`       varchar(16) DEFAULT NULL,
    `switch_v_ca`     varchar(16) DEFAULT NULL,
    `switch_ic`       varchar(16) DEFAULT NULL,
    `GGJ`             varchar(32) DEFAULT NULL,
    `inspect_task_id` int(11)     DEFAULT NULL,
    `power_number`    varchar(32) NOT NULL,
    `power_station`   int(11)     DEFAULT NULL,
    `cos`             float       DEFAULT NULL,
    `power`           float       DEFAULT NULL,
    `outline`         int(11)     DEFAULT NULL,
    `temperature_a`   float       DEFAULT NULL,
    `temperature_b`   float       DEFAULT NULL,
    `temperature_c`   float       DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    KEY `inspect_task_id` (`inspect_task_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `inspection_plan`
(
    `id`           int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)                             NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `plan_date`    datetime    DEFAULT NULL,
    `status`       varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `leader_id`    int(11)     DEFAULT NULL,
    `station_id`   int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    KEY `leader_id` (`leader_id`) USING BTREE,
    KEY `station_id` (`station_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `inspection_task`
(
    `id`           int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)                             NOT NULL,
    `created_time` datetime(6)                            DEFAULT NULL,
    `updated_time` datetime(6)                            DEFAULT NULL,
    `deleted_time` datetime(6)                            DEFAULT NULL,
    `name`         varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `status`       varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `tag`          varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `work_date`    datetime                               DEFAULT NULL,
    `assign_date`  datetime                               DEFAULT NULL,
    `start_time`   datetime(6)                            DEFAULT NULL,
    `end_time`     datetime(6)                            DEFAULT NULL,
    `plan_id`      int(11)                                DEFAULT NULL,
    `team_id`      int(11)                                DEFAULT NULL,
    `confirm`      tinyint(1)                             DEFAULT '0',
    `type`         int(11)                                DEFAULT '0',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `plan_id` (`plan_id`) USING BTREE,
    KEY `team_id` (`team_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `inspection_task_record`
(
    `id`                 int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`            tinyint(1) NOT NULL,
    `created_time`       datetime(6) DEFAULT NULL,
    `updated_time`       datetime(6) DEFAULT NULL,
    `deleted_time`       datetime(6) DEFAULT NULL,
    `content`            longtext   NOT NULL,
    `inspection_task_id` int(11)     DEFAULT NULL,
    `operator_id`        int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    KEY `inspection_task_id` (`inspection_task_id`) USING BTREE,
    KEY `operator_id` (`operator_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `learningcenter_knowledgepoint`
(
    `deleted`                     tinyint(1)   NOT NULL,
    `created_time`                datetime(6)  DEFAULT NULL,
    `updated_time`                datetime(6)  DEFAULT NULL,
    `deleted_time`                datetime(6)  DEFAULT NULL,
    `id`                          int(11)      NOT NULL AUTO_INCREMENT,
    `title`                       varchar(128) NOT NULL,
    `abstract`                    varchar(256) DEFAULT NULL,
    `text`                        longtext     NOT NULL,
    `knowledge_type`              varchar(16)  NOT NULL,
    `is_key_knowledge`            tinyint(1)   DEFAULT NULL,
    `cover_picture`               varchar(256) DEFAULT NULL,
    `visit_nums`                  int(11)      NOT NULL,
    `operator`                    varchar(20)  DEFAULT NULL,
    `knowledge_warehouse_type_id` int(11)      DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `learningcenter_knowledgerepository`
(
    `id`           int(11)      NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)   NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `name`         varchar(128) NOT NULL,
    `is_hot`       tinyint(1)   NOT NULL,
    `operator`     varchar(20) DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `name` (`name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `material`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `name`          varchar(32)    DEFAULT NULL,
    `specification` varchar(32)    DEFAULT NULL,
    `code`          varchar(32)    DEFAULT NULL,
    `price`         decimal(10, 0) DEFAULT '0',
    `deleted`       tinyint(1)     DEFAULT '0',
    `created_time`  datetime       DEFAULT NULL,
    `updated_time`  datetime       DEFAULT NULL,
    `deleted_time`  datetime       DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `message`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `title`        varchar(32)   DEFAULT NULL,
    `content`      varchar(1024) DEFAULT NULL,
    `sender`       int(11)       DEFAULT NULL,
    `send_type`    varchar(32)   DEFAULT '2',
    `type`         varchar(32)   DEFAULT NULL,
    `deleted`      tinyint(1)    DEFAULT '0',
    `created_time` datetime      DEFAULT NULL,
    `updated_time` datetime      DEFAULT NULL,
    `deleted_time` datetime      DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `monitor_device`
(
    `id`               int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`          tinyint(1) NOT NULL,
    `created_time`     datetime(6) DEFAULT NULL,
    `updated_time`     datetime(6) DEFAULT NULL,
    `deleted_time`     datetime(6) DEFAULT NULL,
    `manufacturer`     int(11)     DEFAULT NULL,
    `model`            int(11)     DEFAULT NULL,
    `imei`             varchar(32) DEFAULT NULL,
    `network_type`     int(11)     DEFAULT NULL,
    `sim`              varchar(32) DEFAULT NULL,
    `status`           int(11)    NOT NULL,
    `monitor_point_id` int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `monitor_points`
(
    `id`                  int(11)     NOT NULL AUTO_INCREMENT,
    `deleted`             tinyint(1)  NOT NULL,
    `created_time`        datetime(6)   DEFAULT NULL,
    `updated_time`        datetime(6)   DEFAULT NULL,
    `deleted_time`        datetime(6)   DEFAULT NULL,
    `name`                varchar(32) NOT NULL,
    `power_number`        varchar(32)   DEFAULT NULL,
    `frequency`           int(11)       DEFAULT NULL,
    `comments`            varchar(1024) DEFAULT NULL,
    `customer_id`         int(11)       DEFAULT NULL,
    `electricity_user_id` int(11)       DEFAULT NULL,
    `equipment_id`        int(11)       DEFAULT NULL,
    `station_id`          int(11)       DEFAULT NULL,
    `status`              tinyint(4)    DEFAULT '1',
    PRIMARY KEY (`id`),
    KEY `customer_id` (`customer_id`),
    KEY `electricity_user_id` (`electricity_user_id`),
    KEY `equipment_id` (`equipment_id`),
    KEY `station_id` (`station_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `notification`
(
    `id`                            int(11)      NOT NULL AUTO_INCREMENT,
    `level`                         varchar(20)  NOT NULL,
    `unread`                        tinyint(1)   NOT NULL,
    `actor_object_id`               varchar(255) NOT NULL,
    `verb`                          varchar(255) NOT NULL,
    `description`                   longtext,
    `target_object_id`              varchar(255) DEFAULT NULL,
    `action_object_object_id`       varchar(255) DEFAULT NULL,
    `timestamp`                     datetime(6)  NOT NULL,
    `public`                        tinyint(1)   NOT NULL,
    `action_object_content_type_id` int(11)      DEFAULT NULL,
    `actor_content_type_id`         int(11)      NOT NULL,
    `recipient_id`                  int(11)      NOT NULL,
    `target_content_type_id`        int(11)      DEFAULT NULL,
    `deleted`                       tinyint(1)   NOT NULL,
    `emailed`                       tinyint(1)   NOT NULL,
    `data`                          longtext,
    PRIMARY KEY (`id`),
    KEY `notifications_notifi_action_object_conten_7d2b8ee9_fk_django_co` (`action_object_content_type_id`),
    KEY `notifications_notifi_actor_content_type_i_0c69d7b7_fk_django_co` (`actor_content_type_id`),
    KEY `notifications_notifi_target_content_type__ccb24d88_fk_django_co` (`target_content_type_id`),
    KEY `notifications_notification_deleted_b32b69e6` (`deleted`),
    KEY `notifications_notification_emailed_23a5ad81` (`emailed`),
    KEY `notifications_notification_public_1bc30b1c` (`public`),
    KEY `notifications_notification_unread_cce4be30` (`unread`),
    KEY `notifications_notification_timestamp_6a797bad` (`timestamp`),
    KEY `notifications_notification_recipient_id_unread_253aadc9_idx` (`recipient_id`, `unread`),
    CONSTRAINT `notifications_notifi_action_object_conten_7d2b8ee9_fk_django_co` FOREIGN KEY (`action_object_content_type_id`) REFERENCES `django_content_type` (`id`),
    CONSTRAINT `notifications_notifi_actor_content_type_i_0c69d7b7_fk_django_co` FOREIGN KEY (`actor_content_type_id`) REFERENCES `django_content_type` (`id`),
    CONSTRAINT `notifications_notifi_target_content_type__ccb24d88_fk_django_co` FOREIGN KEY (`target_content_type_id`) REFERENCES `django_content_type` (`id`),
    CONSTRAINT `notifications_notification_recipient_id_d055f3f0_fk_accounts_id` FOREIGN KEY (`recipient_id`) REFERENCES `accounts` (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `order`
(
    `id`                int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`           tinyint(1)                             NOT NULL,
    `created_time`      datetime(6)                                     DEFAULT NULL,
    `updated_time`      datetime(6)                                     DEFAULT NULL,
    `deleted_time`      datetime(6)                                     DEFAULT NULL,
    `name`              varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
    `content`           longtext COLLATE utf8mb4_unicode_ci,
    `commencement_date` date                                            DEFAULT NULL,
    `file`              longtext COLLATE utf8mb4_unicode_ci,
    `conclusion`        longtext COLLATE utf8mb4_unicode_ci,
    `receiving_time`    datetime(6)                                     DEFAULT NULL,
    `status`            varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `type`              varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `start_time`        datetime(6)                                     DEFAULT NULL,
    `finish_time`       datetime(6)                                     DEFAULT NULL,
    `handler_id`        int(11)                                         DEFAULT NULL,
    `recipient_id`      int(11)                                         DEFAULT NULL,
    `task_id`           int(11)                                         DEFAULT NULL,
    `team_id`           int(11)                                         DEFAULT NULL,
    `transfer_reason`   varchar(256) COLLATE utf8mb4_unicode_ci         DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `handler_id` (`handler_id`),
    KEY `recipient_id` (`recipient_id`),
    KEY `task_id` (`task_id`),
    KEY `team_id` (`team_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `order_record`
(
    `id`            int(11)                                 NOT NULL AUTO_INCREMENT,
    `deleted`       tinyint(1)                              NOT NULL,
    `created_time`  datetime(6) DEFAULT NULL,
    `updated_time`  datetime(6) DEFAULT NULL,
    `deleted_time`  datetime(6) DEFAULT NULL,
    `problem`       varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
    `describe`      longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `investigation` longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `handle`        longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `proposal`      longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `operator_id`   int(11)     DEFAULT NULL,
    `order_id`      int(11)     DEFAULT NULL,
    `is_finish`     tinyint(1)  DEFAULT '0',
    PRIMARY KEY (`id`),
    KEY `operator_id` (`operator_id`),
    KEY `order_id` (`order_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `organization`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `name`          varchar(64) DEFAULT '',
    `parent_id`     int(11)     DEFAULT NULL,
    `deleted`       tinyint(4)  DEFAULT '0',
    `created_time`  datetime    DEFAULT NULL,
    `updated_time`  datetime    DEFAULT NULL,
    `deleted_time`  datetime    DEFAULT NULL,
    `enterprise_id` int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `parent_id` (`parent_id`),
    KEY `enterprise_id` (`enterprise_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `outline`
(
    `id`              int(11) NOT NULL AUTO_INCREMENT,
    `name`            varchar(128) DEFAULT NULL,
    `powerstation_id` int(11)      DEFAULT NULL,
    `deleted`         tinyint(1)   DEFAULT '0',
    `created_time`    datetime     DEFAULT NULL,
    `updated_time`    datetime     DEFAULT NULL,
    `deleted_time`    datetime     DEFAULT NULL,
    `power_number`    varchar(16)  DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `powerstation_id` (`powerstation_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `perms`
(
    `id`           int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)                             NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `name`         varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `code`         int(11)                                NOT NULL,
    `kind`         varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `group`        varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `desc`         varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `name` (`name`),
    UNIQUE KEY `code` (`code`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `power_inspection_data`
(
    `id`                 int(11) NOT NULL AUTO_INCREMENT,
    `inspection_task_id` int(11)     DEFAULT NULL,
    `power_number`       varchar(32) DEFAULT NULL,
    `meter_number`       varchar(32) DEFAULT NULL,
    `multiplying_power`  float       DEFAULT NULL,
    `power_factor`       float       DEFAULT NULL,
    `total_active_power` float       DEFAULT NULL,
    `peak`               float       DEFAULT NULL,
    `flat_1`             float       DEFAULT NULL,
    `flat_2`             float       DEFAULT NULL,
    `valley`             float       DEFAULT NULL,
    `peak_md`            float       DEFAULT NULL,
    `flat_1_md`          float       DEFAULT NULL,
    `flat_2_md`          float       DEFAULT NULL,
    `valley_md`          float       DEFAULT NULL,
    `max_md`             float       DEFAULT NULL,
    `declare_md`         float       DEFAULT NULL,
    `total_capacity`     float       DEFAULT NULL,
    `voltage_level`      varchar(32) DEFAULT NULL,
    `real_capacity`      float       DEFAULT NULL,
    `real_power_factor`  float       DEFAULT NULL,
    `reactive_power_1`   float       DEFAULT NULL,
    `reactive_power_2`   float       DEFAULT NULL,
    `deleted`            tinyint(1)  DEFAULT '0',
    `created_time`       datetime    DEFAULT NULL,
    `updated_time`       datetime    DEFAULT NULL,
    `deleted_time`       datetime    DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    KEY `inspection_task_id` (`inspection_task_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `power_log`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `order_id`     int(11)    DEFAULT NULL,
    `time`         datetime   DEFAULT NULL,
    `content`      text,
    `file`         text,
    `picture`      text,
    `file_title`   text,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `order_id` (`order_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `power_station`
(
    `id`                    int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`               tinyint(1) NOT NULL                     DEFAULT '0',
    `created_time`          datetime(6)                             DEFAULT NULL,
    `updated_time`          datetime(6)                             DEFAULT NULL,
    `deleted_time`          datetime(6)                             DEFAULT NULL,
    `name`                  varchar(64) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `addr`                  varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `city_code`             varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `ad_code`               varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `operation_level`       varchar(16) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `person`                varchar(64) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `phone`                 varchar(16) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `file`                  varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `status`                tinyint(1)                              DEFAULT '1',
    `inspections_number`    int(11)                                 DEFAULT NULL,
    `total_capacity`        double                                  DEFAULT NULL,
    `real_capacity`         double                                  DEFAULT NULL,
    `customer_id`           int(11)                                 DEFAULT NULL,
    `electricity_user_id`   int(11)                                 DEFAULT NULL,
    `start_time`            datetime                                DEFAULT NULL,
    `end_time`              datetime                                DEFAULT NULL,
    `customize_time`        datetime                                DEFAULT NULL,
    `electric_test_time`    datetime                                DEFAULT NULL,
    `file_id`               varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `inspection_template`   int(11)                                 DEFAULT NULL,
    `inspection_time`       varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `inspection_type`       smallint(6)                             DEFAULT NULL,
    `service_enterprise_id` int(11)                                 DEFAULT '1',
    `inspector_ids`         varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `service_team`          varchar(64) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `location`              varchar(64) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `customer_id` (`customer_id`),
    KEY `electricity_user_id` (`electricity_user_id`),
    KEY `service_enterprise_id` (`service_enterprise_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `role_perms`
(
    `id`           int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1) NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `perms_id`     int(11)     DEFAULT NULL,
    `role_id`      int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `roles`
(
    `id`           int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1)                             NOT NULL,
    `created_time` datetime(6)                             DEFAULT NULL,
    `updated_time` datetime(6)                             DEFAULT NULL,
    `deleted_time` datetime(6)                             DEFAULT NULL,
    `name`         varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `kind`         varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `kind_id`      varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `comments`     varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT '',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `safety_equipment`
(
    `id`                  int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`             tinyint(1) NOT NULL,
    `created_time`        datetime(6)                            DEFAULT NULL,
    `updated_time`        datetime(6)                            DEFAULT NULL,
    `deleted_time`        datetime(6)                            DEFAULT NULL,
    `electroprobe_status` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `es_check_date`       date                                   DEFAULT NULL,
    `ground_wire`         varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `gw_check_date`       date                                   DEFAULT NULL,
    `insulating_mat`      varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `im_check_date`       date                                   DEFAULT NULL,
    `insulating_gloves`   varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `ig_check_date`       date                                   DEFAULT NULL,
    `insulating_shoes`    varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_check_date`       date                                   DEFAULT NULL,
    `extinguisher`        varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `ex_check_date`       date                                   DEFAULT NULL,
    `station_id`          int(11)                                DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `serial_number`
(
    `id`           int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1) NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `number`       int(11)    NOT NULL,
    `last_number`  int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `silk_request`
(
    `id`                      varchar(36) COLLATE utf8mb4_unicode_ci  NOT NULL,
    `path`                    varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL,
    `query_params`            longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `raw_body`                longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `body`                    longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `method`                  varchar(10) COLLATE utf8mb4_unicode_ci  NOT NULL,
    `start_time`              datetime(6)                             NOT NULL,
    `view_name`               varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `end_time`                datetime(6)                             DEFAULT NULL,
    `time_taken`              double                                  DEFAULT NULL,
    `encoded_headers`         longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `meta_time`               double                                  DEFAULT NULL,
    `meta_num_queries`        int(11)                                 DEFAULT NULL,
    `meta_time_spent_queries` double                                  DEFAULT NULL,
    `pyprofile`               longtext COLLATE utf8mb4_unicode_ci     NOT NULL,
    `num_sql_queries`         int(11)                                 NOT NULL,
    `prof_file`               varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`),
    KEY `silk_request_path_9f3d798e` (`path`),
    KEY `silk_request_start_time_1300bc58` (`start_time`),
    KEY `silk_request_view_name_68559f7b` (`view_name`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `silk_sqlquery`
(
    `id`         int(11)                             NOT NULL AUTO_INCREMENT,
    `query`      longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    `start_time` datetime(6)                            DEFAULT NULL,
    `end_time`   datetime(6)                            DEFAULT NULL,
    `time_taken` double                                 DEFAULT NULL,
    `traceback`  longtext COLLATE utf8mb4_unicode_ci NOT NULL,
    `request_id` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `identifier` int(11)                             NOT NULL,
    PRIMARY KEY (`id`),
    KEY `silk_sqlquery_request_id_6f8f0527_fk_silk_request_id` (`request_id`),
    CONSTRAINT `silk_sqlquery_request_id_6f8f0527_fk_silk_request_id` FOREIGN KEY (`request_id`) REFERENCES `silk_request` (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `silk_profile`
(
    `id`               int(11)                                 NOT NULL AUTO_INCREMENT,
    `name`             varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
    `start_time`       datetime(6)                             NOT NULL,
    `end_time`         datetime(6)                            DEFAULT NULL,
    `time_taken`       double                                 DEFAULT NULL,
    `file_path`        varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
    `line_num`         int(11)                                DEFAULT NULL,
    `end_line_num`     int(11)                                DEFAULT NULL,
    `func_name`        varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
    `exception_raised` tinyint(1)                              NOT NULL,
    `dynamic`          tinyint(1)                              NOT NULL,
    `request_id`       varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `silk_profile_request_id_7b81bd69_fk_silk_request_id` (`request_id`),
    CONSTRAINT `silk_profile_request_id_7b81bd69_fk_silk_request_id` FOREIGN KEY (`request_id`) REFERENCES `silk_request` (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `silk_profile_queries`
(
    `id`          int(11) NOT NULL AUTO_INCREMENT,
    `profile_id`  int(11) NOT NULL,
    `sqlquery_id` int(11) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `silk_profile_queries_profile_id_sqlquery_id_b2403d9b_uniq` (`profile_id`, `sqlquery_id`),
    KEY `silk_profile_queries_sqlquery_id_155df455_fk_silk_sqlquery_id` (`sqlquery_id`),
    CONSTRAINT `silk_profile_queries_profile_id_a3d76db8_fk_silk_profile_id` FOREIGN KEY (`profile_id`) REFERENCES `silk_profile` (`id`),
    CONSTRAINT `silk_profile_queries_sqlquery_id_155df455_fk_silk_sqlquery_id` FOREIGN KEY (`sqlquery_id`) REFERENCES `silk_sqlquery` (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `silk_response`
(
    `id`              varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
    `status_code`     int(11)                                NOT NULL,
    `raw_body`        longtext COLLATE utf8mb4_unicode_ci    NOT NULL,
    `body`            longtext COLLATE utf8mb4_unicode_ci    NOT NULL,
    `encoded_headers` longtext COLLATE utf8mb4_unicode_ci    NOT NULL,
    `request_id`      varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `request_id` (`request_id`),
    CONSTRAINT `silk_response_request_id_1e8e2776_fk_silk_request_id` FOREIGN KEY (`request_id`) REFERENCES `silk_request` (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `station_building`
(
    `id`                   int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`              tinyint(1) NOT NULL,
    `created_time`         datetime(6)                            DEFAULT NULL,
    `updated_time`         datetime(6)                            DEFAULT NULL,
    `cable_holes_status`   varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `deleted_time`         datetime(6)                            DEFAULT NULL,
    `cable_conduit_status` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `frame_status`         varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `ground_status`        varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `window_status`        varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `house_status`         varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `station_id`           int(11)                                DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `tags`
(
    `id`           int(11) unsigned NOT NULL AUTO_INCREMENT,
    `name`         varchar(64)      NOT NULL DEFAULT '',
    `deleted`      tinyint(4)                DEFAULT '0',
    `created_time` datetime                  DEFAULT NULL,
    `updated_time` datetime                  DEFAULT NULL,
    `deleted_time` datetime                  DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `task`
(
    `id`             int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`        tinyint(1)                             NOT NULL,
    `created_time`   datetime(6)                             DEFAULT NULL,
    `updated_time`   datetime(6)                             DEFAULT NULL,
    `deleted_time`   datetime(6)                             DEFAULT NULL,
    `name`           varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `type`           varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `subtype`        varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `status`         varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `reason`         varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `describe`       longtext COLLATE utf8mb4_unicode_ci,
    `contacts`       varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `contacts_phone` varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `addr`           varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `is_cost`        tinyint(1)                             NOT NULL,
    `finish_time`    datetime(6)                             DEFAULT NULL,
    `file`           longtext COLLATE utf8mb4_unicode_ci,
    `finished_tag`   tinyint(1)                             NOT NULL,
    `confirm`        tinyint(1)                             NOT NULL,
    `number`         varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `plan_date`      datetime(6)                             DEFAULT NULL,
    `remarks`        longtext COLLATE utf8mb4_unicode_ci,
    `contract_id`    int(11)                                 DEFAULT NULL,
    `customer_id`    int(11)                                 DEFAULT NULL,
    `equipment_id`   int(11)                                 DEFAULT NULL,
    `station_id`     int(11)                                 DEFAULT NULL,
    `location`       varchar(64) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `dispatcher`     varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `source`         varchar(32) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `ele_user`       varchar(16) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `number` (`number`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `team`
(
    `id`              int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`         tinyint(1)                             NOT NULL DEFAULT '0',
    `created_time`    datetime(6)                                     DEFAULT NULL,
    `updated_time`    datetime(6)                                     DEFAULT NULL,
    `deleted_time`    datetime(6)                                     DEFAULT NULL,
    `name`            varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `type`            varchar(16) COLLATE utf8mb4_unicode_ci          DEFAULT '1',
    `car_number`      varchar(16) COLLATE utf8mb4_unicode_ci          DEFAULT NULL,
    `leader_id`       int(11)                                         DEFAULT NULL,
    `team_headman_id` int(11)                                         DEFAULT NULL,
    `enterprise_id`   int(11)                                         DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `leader_id` (`leader_id`),
    KEY `team_headman_id` (`team_headman_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `team_member`
(
    `id`       int(11) NOT NULL AUTO_INCREMENT,
    `team_id`  int(11) NOT NULL,
    `users_id` int(11) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `team_member_team_id_users_id_50470e6d_uniq` (`team_id`, `users_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `team_number`
(
    `id`           int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1) NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `member_id`    int(11)     DEFAULT NULL,
    `team_id`      int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `team_id` (`team_id`, `member_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `team_schedule`
(
    `deleted`       tinyint(1) NOT NULL,
    `created_time`  datetime(6) DEFAULT NULL,
    `updated_time`  datetime(6) DEFAULT NULL,
    `deleted_time`  datetime(6) DEFAULT NULL,
    `id`            int(11)    NOT NULL AUTO_INCREMENT,
    `schedule_date` date       NOT NULL,
    `team_id`       int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `team_id` (`team_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `transformer`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `station_id`    int(11)      DEFAULT NULL,
    `number`        int(11)      DEFAULT NULL,
    `capacity`      float        DEFAULT NULL,
    `real_capacity` float        DEFAULT NULL,
    `comments`      varchar(256) DEFAULT NULL,
    `ele_number`    varchar(32)  DEFAULT NULL,
    `deleted`       tinyint(1)   DEFAULT '0',
    `created_time`  datetime     DEFAULT NULL,
    `updated_time`  datetime     DEFAULT NULL,
    `deleted_time`  datetime     DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `user_enterprise`
(
    `id`            int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`       tinyint(1) NOT NULL                    DEFAULT '0',
    `created_time`  datetime(6)                            DEFAULT NULL,
    `updated_time`  datetime(6)                            DEFAULT NULL,
    `deleted_time`  datetime(6)                            DEFAULT NULL,
    `enterprise_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `user_id`       int(11)                                DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `enterprise_id` (`enterprise_id`),
    KEY `user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `user_location`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `user_id`      int(11)     DEFAULT NULL,
    `location`     varchar(32) DEFAULT NULL,
    `deleted`      tinyint(1)  DEFAULT '0',
    `created_time` datetime    DEFAULT NULL,
    `updated_time` datetime    DEFAULT NULL,
    `deleted_time` datetime    DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `user_message`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `user_id`      int(11)    DEFAULT NULL,
    `message_id`   int(11)    DEFAULT NULL,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `user_organizations`
(
    `id`              int(11) unsigned NOT NULL AUTO_INCREMENT,
    `user_id`         int(11)    DEFAULT NULL,
    `organization_id` int(11)    DEFAULT NULL,
    `deleted`         tinyint(4) DEFAULT '0',
    `created_time`    datetime   DEFAULT NULL,
    `updated_time`    datetime   DEFAULT NULL,
    `deleted_time`    datetime   DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `user_roles`
(
    `id`           int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`      tinyint(1) NOT NULL,
    `created_time` datetime(6) DEFAULT NULL,
    `updated_time` datetime(6) DEFAULT NULL,
    `deleted_time` datetime(6) DEFAULT NULL,
    `role_id`      int(11)     DEFAULT NULL,
    `user_id`      int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `role_id` (`role_id`),
    KEY `user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `user_tags`
(
    `id`           int(11) unsigned NOT NULL AUTO_INCREMENT,
    `user_id`      int(11)    DEFAULT NULL,
    `tag_id`       int(11)    DEFAULT NULL,
    `deleted`      tinyint(4) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `tag_id` (`tag_id`),
    KEY `user_id` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `users`
(
    `id`                int(11)    NOT NULL AUTO_INCREMENT,
    `deleted`           tinyint(1) NOT NULL                    DEFAULT '0',
    `created_time`      datetime(6)                            DEFAULT NULL,
    `updated_time`      datetime(6)                            DEFAULT NULL,
    `deleted_time`      datetime(6)                            DEFAULT NULL,
    `nickname`          varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `wechat`            varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `phone`             varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `email`             varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `order_rec_setting` tinyint(1)                             DEFAULT NULL,
    `order_rec_status`  tinyint(1)                             DEFAULT NULL,
    `account_id`        int(11)                                DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `account_id` (`account_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `videos`
(
    `id`    int(11) unsigned NOT NULL AUTO_INCREMENT,
    `name`  varchar(32)   DEFAULT NULL,
    `token` varchar(1024) DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;


CREATE TABLE `work_log`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `content`      text,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL,
    `task_id`      int(11)    DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `task_id` (`task_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `work_ticket`
(
    `id`                        int(11)                                NOT NULL AUTO_INCREMENT,
    `deleted`                   tinyint(1)                             NOT NULL,
    `created_time`              datetime(6)                              DEFAULT NULL,
    `updated_time`              datetime(6)                              DEFAULT NULL,
    `deleted_time`              datetime(6)                              DEFAULT NULL,
    `code`                      varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
    `type`                      smallint(6)                            NOT NULL,
    `addr`                      varchar(256) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `job_content`               longtext COLLATE utf8mb4_unicode_ci,
    `plan_start_time`           datetime(6)                              DEFAULT NULL,
    `plan_end_time`             datetime(6)                              DEFAULT NULL,
    `safety_measure`            longtext COLLATE utf8mb4_unicode_ci,
    `file`                      varchar(256) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `issue_time`                datetime(6)                              DEFAULT NULL,
    `weather`                   varchar(32) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `supplement`                longtext COLLATE utf8mb4_unicode_ci,
    `person_num`                int(11)                                  DEFAULT NULL,
    `person_name`               varchar(256) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `finished_time`             datetime(6)                              DEFAULT NULL,
    `checked`                   longtext COLLATE utf8mb4_unicode_ci,
    `remarks`                   longtext COLLATE utf8mb4_unicode_ci,
    `the_end`                   longtext COLLATE utf8mb4_unicode_ci,
    `work_conditions`           longtext COLLATE utf8mb4_unicode_ci,
    `attention`                 longtext COLLATE utf8mb4_unicode_ci,
    `customer_id`               int(11)                                  DEFAULT NULL,
    `issuer_id`                 int(11)                                  DEFAULT NULL,
    `order_id`                  int(11)                                  DEFAULT NULL,
    `person_liable_id`          int(11)                                  DEFAULT NULL,
    `station_id`                int(11)                                  DEFAULT NULL,
    `team_id`                   int(11)                                  DEFAULT NULL,
    `delay`                     datetime                                 DEFAULT NULL,
    `delay_leader`              varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `delay_licensor`            varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `supplement_safety_measure` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `last_leader`               varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `allow_start_time`          datetime                                 DEFAULT NULL,
    `allower`                   varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `delay_date`                datetime                                 DEFAULT NULL,
    `other`                     varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `handover_confirm`          varchar(256) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `nameplate_operator`        varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `nameplate_supervisor`      varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `supervisor`                varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `supervisor_event`          varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `leader_change_issuer`      varchar(16) COLLATE utf8mb4_unicode_ci   DEFAULT NULL,
    `leade_change_date`         datetime                                 DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `customer_id` (`customer_id`),
    KEY `issuer_id` (`issuer_id`),
    KEY `order_id` (`order_id`),
    KEY `person_liable_id` (`person_liable_id`),
    KEY `station_id` (`station_id`),
    KEY `team_id` (`team_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


CREATE TABLE `wt_child_ticket`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `code`         varchar(32) DEFAULT NULL,
    `team`         int(11)     DEFAULT NULL,
    `leader`       varchar(16) DEFAULT NULL,
    `issue_time`   datetime    DEFAULT NULL,
    `end_time`     datetime    DEFAULT NULL,
    `created_time` datetime    DEFAULT NULL,
    `updated_time` datetime    DEFAULT NULL,
    `work_ticket`  int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `wt_contact`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `content`      varchar(1024) DEFAULT NULL,
    `leader`       varchar(16)   DEFAULT NULL,
    `issuer`       varchar(16)   DEFAULT NULL,
    `time`         datetime      DEFAULT NULL,
    `created_time` datetime      DEFAULT NULL,
    `updated_time` datetime      DEFAULT NULL,
    `work_ticket`  int(11)       DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `wt_person_changes`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `person_add`    varchar(16) DEFAULT NULL,
    `add_time`      datetime    DEFAULT NULL,
    `add_issuer`    varchar(16) DEFAULT NULL,
    `person_remove` varchar(16) DEFAULT NULL,
    `remove_time`   datetime    DEFAULT NULL,
    `remove_issuer` varchar(16) DEFAULT NULL,
    `created_time`  datetime    DEFAULT NULL,
    `updated_time`  datetime    DEFAULT NULL,
    `work_ticket`   int(11)     DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `wt_safety_measure`
(
    `id`                      int(11) NOT NULL AUTO_INCREMENT,
    `content`                 varchar(1024) DEFAULT NULL,
    `content_done`            tinyint(1)    DEFAULT NULL,
    `supplement_content`      varchar(1024) DEFAULT NULL,
    `supplement_content_done` tinyint(1)    DEFAULT NULL,
    `created_time`            datetime      DEFAULT NULL,
    `updated_time`            datetime      DEFAULT NULL,
    `type`                    varchar(32)   DEFAULT NULL,
    `work_ticket`             int(11)       DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `wt_work_change`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `addr`         varchar(256) DEFAULT NULL,
    `start_time`   datetime     DEFAULT NULL,
    `leader`       varchar(16)  DEFAULT NULL,
    `end_time`     datetime     DEFAULT NULL,
    `created_time` datetime     DEFAULT NULL,
    `updated_time` datetime     DEFAULT NULL,
    `work_ticket`  int(11)      DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `wt_work_record`
(
    `id`            int(11) NOT NULL AUTO_INCREMENT,
    `start_time`    datetime DEFAULT NULL,
    `finish_time`   datetime DEFAULT NULL,
    `person_liable` int(11)  DEFAULT NULL,
    `licensor`      int(11)  DEFAULT NULL,
    `work_ticket`   int(11)  DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;


CREATE TABLE `app_version`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT,
    `version`      varchar(16)  DEFAULT NULL,
    `package_url`  varchar(256) DEFAULT NULL,
    `deleted`      tinyint(1)   DEFAULT '0',
    `created_time` datetime     DEFAULT NULL,
    `updated_time` datetime     DEFAULT NULL,
    `deleted_time` datetime     DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

create table crm_customer
(
    id               int primary key auto_increment,
    customer_id      int          null,
    level            varchar(32)  null COMMENT '客户等级',
    salesman_id      int          null comment '业务员id',
    status           varchar(16)  null comment '状态',
    type             varchar(16)  null comment '客户类型',
    intention        boolean      null comment '客户意向',
    intention_remark varchar(256) null comment '意向备注',
    power_number     float        null comment '月用电量',
    power_data       text         null comment '电气信息',
    is_sign          boolean    default false comment '是否签约',
    `deleted`        tinyint(1) DEFAULT '0' comment '删除状态',
    `created_time`   datetime   DEFAULT NULL comment '创建时间',
    `updated_time`   datetime   DEFAULT NULL comment '更新时间',
    `deleted_time`   datetime   DEFAULT NULL comment '删除时间'

);

create table crm_customer_remark
(
    id             int primary key auto_increment,
    customer_id    int          null,
    content        varchar(256) null,
    account_id     int          null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table crm_plan
(
    id             int primary key auto_increment,
    name           varchar(32) null,
    customer_id    int         null,
    type           varchar(32) null,
    contract_id    int         null,
    status         varchar(16) null,
    recent_code    int         null,
    start_time     datetime    null,
    creater_id     int         null,
    end_time       datetime    null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL

);

create table crm_code
(
    id             int primary key auto_increment,
    name           varchar(32) null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table crm_plan_code
(
    id             int primary key auto_increment,
    plan_id        int          null,
    code_id        int          null,
    `index`        int          null,
    duration       int          null,
    file           varchar(256) null,
    status         varchar(16)  null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);


create table crm_customer_clue
(
    id                    int primary key auto_increment,
    name                  varchar(64)  null,
    level                 varchar(16)  null,
    type                  varchar(16)  null,
    service_staff_id      int          null,
    last_service_staff_id int          null,
    address               varchar(128) null,
    adcode                varchar(16)  null,
    city_code             varchar(16)  null,
    district              varchar(16)  null,
    longitude             varchar(32)  null,
    latitude              varchar(32)  null,
    legal_person          varchar(16)  null,
    legal_person_phone    varchar(16)  null,
    tax_num               varchar(64)  null,
    bank_account_name     varchar(64)  null,
    bank_name             varchar(64)  null,
    postcode              varchar(16)  null,
    scale                 varchar(64)  null,
    nature                varchar(64)  null comment '企业性质',
    industry              varchar(64)  null comment '所属行业',
    asset                 varchar(32)  null comment '资产规模',
    covered_area          varchar(32)  null comment '占地面积',
    logo                  varchar(128) null,
    file                  varchar(128) null comment '附件',
    parent_enterprise_id  int          null comment '父级企业id',
    contact               text         null comment '客户联系人',
    power_data            text         null comment '电气信息',
    power_number          float        null comment '月用电量',
    circuit_diagram       varchar(128) null comment '一次线路图',
    panorama              varchar(128) null comment '站内全貌图',
    gate_image            varchar(128) null comment '客户门脸图',
    electricity_bill      varchar(128) null comment '电费账单',
    customer_id           int          null comment '所属客户',
    plan_id               int          null comment '所属计划',
    status                varchar(32)  null comment '状态',
    `deleted`             tinyint(1) DEFAULT '0',
    `created_time`        datetime   DEFAULT NULL,
    `updated_time`        datetime   DEFAULT NULL,
    `deleted_time`        datetime   DEFAULT NULL

);

create table crm_customer_operation_record
(
    id             int primary key auto_increment,
    customer_id    int         null comment '所属客户',
    plan_id        int         null comment '所属计划',
    content        varchar(64) null comment '内容',
    account_id     int         null comment '操作账号',
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table crm_task
(
    id              int primary key auto_increment,
    type            varchar(16)  null comment '任务类型',
    code_id         int          null comment '所属节点',
    status          varchar(16)  null comment '状态',
    remark          varchar(32)  null comment '备注',
    customer_id     int          null comment '所属客户',
    plan_id         int          null comment '所属计划',
    intention       boolean      null comment '客户意向',
    urgent          boolean    default false comment '是否催办',
    submitter_id    int          null comment '提交人',
    file            varchar(256) null comment '文件',
    contact         text         null comment '客户联系人',
    contract_id     varchar(32)  null,
    ele_user        text         null comment '户号',
    approval_status varchar(16)  null comment '审批状态',
    amount          float        null comment '合同金额',
    finish_time     datetime     null comment '完成时间',
    `deleted`       tinyint(1) DEFAULT '0',
    `created_time`  datetime   DEFAULT NULL,
    `updated_time`  datetime   DEFAULT NULL,
    `deleted_time`  datetime   DEFAULT NULL
);

create table crm_task_approval_record
(
    id             int primary key auto_increment,
    task_id        int          null comment '所属任务',
    result         varchar(16)  null comment '审批结果',
    remark         varchar(256) null comment '审批内容',
    reviewer_id    int          null comment '审批人',
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table crm_sign_in
(
    id             int primary key auto_increment,
    user_id        int          null comment '人员',
    address        varchar(64)  null comment '地址',
    customer_id    int          null comment '所属客户',
    time           datetime     null comment '打卡时间',
    file           varchar(128) null comment '文件',
    remark         varchar(128) null comment '备注',
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table crm_customer_visit
(
    id             int primary key auto_increment,
    customer_id    int          null comment '客户id',
    user_id        int          null comment '拜访者',
    content        varchar(64)  null comment '内容',
    visit_time     datetime     null comment '拜访时间',
    remark         varchar(128) null comment '备注',
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL

);

create table crm_message
(
    id             int primary key auto_increment,
    title          varchar(32) null comment '标题',
    content        varchar(64) null comment '内容',
    creater_id     int         null comment '创建人',
    customer_id    int         null comment '所属客户',
    limit_time     datetime    null comment '截止跟进时间',
    plan_id        int         null comment '所属计划',
    task_id        int         null comment '所属任务',
    type           varchar(16) null comment '消息类型',
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table crm_user_message
(
    id         int primary key auto_increment,
    message_id int         null comment '所属消息',
    user_id    int         null comment '接收人',
    status     varchar(16) null comment '状态',
    is_read    boolean default false comment '是否已读',

);