from django.db import models

from common.utils.models import BaseModel


class OpenApiToken(BaseModel):
    name = models.CharField(max_length=64)
    app_id = models.CharField(max_length=32)
    token = models.CharField(max_length=36)
    expired = models.DateTimeField()
    stopped = models.BooleanField(default=0)
    app_range = models.CharField(max_length=32)

    class Meta:
        db_table = "open_api_token"
