# coding=utf-8

import datetime
from sqlalchemy import (Column, INTEGER, BIGINT, DATETIME, NVARCHAR, TEXT,
                        DECIMAL)
from sqlalchemy.ext.declarative import declarative_base

from db.db_client import engine

Base = declarative_base(bind=engine)

# class Monitor_Messages(Base):
#     __tablename__ = 'message'
#
#     id = Column(INTEGER, primary_key=True, autoincrement=True)
#     body = Column(TEXT)
#     key = Column(NVARCHAR(16), nullable=False)
#     iv = Column(NVARCHAR(16), nullable=False)


class Monitor(Base):
    __tablename__ = 'ld_device_data_{}'.format(''.join(
        datetime.datetime.now().strftime('%Y%m').split("/")))

    id = Column(BIGINT, primary_key=True, autoincrement=True)
    no = Column(INTEGER, autoincrement=True, default=0)
    device_imei = Column(NVARCHAR(64), nullable=True)
    building_code = Column(NVARCHAR(64), nullable=True)
    gateway_code = Column(NVARCHAR(64), nullable=True)
    meter_code = Column(NVARCHAR(64), nullable=True)
    day = Column(NVARCHAR(10), nullable=True)
    hour = Column(NVARCHAR(13), nullable=True)
    device_content = Column(TEXT, nullable=True,  default='')
    a_dy = Column(DECIMAL(6, 2), nullable=True, default=-1)
    b_dy = Column(DECIMAL(6, 2), nullable=True, default=-1)
    c_dy = Column(DECIMAL(6, 2), nullable=True, default=-1)
    a_dl = Column(DECIMAL(6, 2), nullable=True, default=-1)
    b_dl = Column(DECIMAL(6, 2), nullable=True, default=-1)
    c_dl = Column(DECIMAL(6, 2), nullable=True, default=-1)
    ab_dy = Column(DECIMAL(6, 2), nullable=True, default=-1)
    bc_dy = Column(DECIMAL(6, 2), nullable=True, default=-1)
    ac_dy = Column(DECIMAL(6, 2), nullable=True, default=-1)
    a_yggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    b_yggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    c_yggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    total_yggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    a_wggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    b_wggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    c_wggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    total_wggl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    a_szgl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    b_szgl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    c_szgl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    total_szgl = Column(DECIMAL(10, 3), nullable=True, default=-1)
    a_glys = Column(DECIMAL(10, 3), nullable=True, default=-1)
    b_glys = Column(DECIMAL(10, 3), nullable=True, default=-1)
    c_glys = Column(DECIMAL(10, 3), nullable=True, default=-1)
    total_glys = Column(DECIMAL(10, 3), nullable=True, default=-1)
    pl = Column(DECIMAL(8, 2), nullable=True, default=-1)
    a_ygdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    b_ygdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    c_ygdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    total_ygdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    a_wgdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    b_wgdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    c_wgdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    total_wgdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    a_szdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    b_szdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    c_szdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    total_szdn = Column(DECIMAL(13, 3), nullable=True, default=-1)
    u_avg = Column(DECIMAL(13, 3), nullable=True, default=-1)
    ul_avg = Column(DECIMAL(13, 3), nullable=True, default=-1)
    l_avg = Column(DECIMAL(13, 3), nullable=True, default=-1)
    wpp = Column(DECIMAL(13, 3), nullable=True, default=-1)
    wqp = Column(DECIMAL(13, 3), nullable=True, default=-1)
    epe = Column(DECIMAL(13, 3), nullable=True, default=-1)
    epi = Column(DECIMAL(13, 3), nullable=True, default=-1)
    epi_f = Column(DECIMAL(13, 3), nullable=True, default=-1)
    epi_g = Column(DECIMAL(13, 3), nullable=True, default=-1)
    epi_j = Column(DECIMAL(13, 3), nullable=True, default=-1)
    epi_p = Column(DECIMAL(13, 3), nullable=True, default=-1)
    md = Column(DECIMAL(13, 3), nullable=True, default=-1)
    create_by = Column(NVARCHAR(64), nullable=True, default=-1)
    create_date = Column(DATETIME, default=datetime.datetime.now())
    update_date = Column(DATETIME, default=datetime.datetime.now())
    update_by = Column(NVARCHAR(64), nullable=True, default='')
    remarks = Column(NVARCHAR(500), nullable=True, default='')
    extend_s1 = Column(NVARCHAR(64), nullable=True, default='')
    extend_s2 = Column(NVARCHAR(64), nullable=True, default='')
    extend_s3 = Column(NVARCHAR(64), nullable=True, default='')
    extend_s4 = Column(NVARCHAR(64), nullable=True, default='')
    extend_s5 = Column(NVARCHAR(64), nullable=True, default='')
    extend_s6 = Column(NVARCHAR(64), nullable=True, default='')
    extend_s7 = Column(NVARCHAR(64), nullable=True, default='')
    extend_s8 = Column(NVARCHAR(64), nullable=True, default='')
    extend_i1 = Column(DECIMAL(8, 0), nullable=True, default=-1)
    extend_i2 = Column(DECIMAL(8, 0), nullable=True, default=-1)
    extend_i3 = Column(DECIMAL(19, 0), nullable=True, default=-1)
    extend_i4 = Column(DECIMAL(19, 0), nullable=True, default=-1)
    extend_f1 = Column(DECIMAL(19, 4), nullable=True, default=-1)
    extend_f2 = Column(DECIMAL(19, 0), nullable=True, default=-1)
    extend_f3 = Column(DECIMAL(19, 0), nullable=True, default=-1)
    extend_f4 = Column(DECIMAL(19, 0), nullable=True, default=-1)
    extend_d1 = Column(DATETIME, default=datetime.datetime.now())
    extend_d2 = Column(DATETIME, default=datetime.datetime.now())
    extend_d3 = Column(DATETIME, default=datetime.datetime.now())
    extend_d4 = Column(DATETIME, default=datetime.datetime.now())
