# coding=utf-8
from abc import ABCMeta, abstractmethod
from addict import Dict


class BaseGatewayAdapter(metaclass=ABCMeta):
    @abstractmethod
    def initial(self, data, protocol):
        ...

    @abstractmethod
    def run_operations(self):
        ...

    @abstractmethod
    def set_requests(self):
        ...

    @abstractmethod
    def responses(self, data):
        ...


def get_request_base_model():
    return Dict({
        "headers": {
            "original_headers": None,
            "head": None,
            "operation": None,
            "length": None,
        },
        "body": {
            "original_body": None,
            "header": None,
            "data": None
        }
    })
