import user_agents
from django.urls import include
from django.conf.urls import url
from django.shortcuts import redirect
from rest_framework import permissions
from drf_yasg.views import get_schema_view
from drf_yasg import openapi

swagger_info = openapi.Info(
    title="法拉第云平台 API",
    default_version='v1',
    description="""法拉第云平台APIv1版本""",
    terms_of_service="https://www.google.com/policies/terms/",
    contact=openapi.Contact(email="contact@snippets.local"),
    license=openapi.License(name="BSD License"),
)

SchemaView = get_schema_view(
    # validators=['ssv', 'flex'],
    public=True,
    permission_classes=(permissions.AllowAny, ),
)


def root_redirect(request):
    user_agent_string = request.META.get('HTTP_USER_AGENT', '')
    user_agent = user_agents.parse(user_agent_string)

    if user_agent.is_mobile:
        schema_view = 'cschema-redoc'
    else:
        schema_view = 'cschema-swagger-ui'

    return redirect(schema_view, permanent=True)


urlpatterns = []

urlpatterns += [
    url(r'^swagger(?P<format>.json|.yaml)$',
        SchemaView.without_ui(cache_timeout=0),
        name='schema-json'),
    url(r'^swagger/$',
        SchemaView.with_ui('swagger', cache_timeout=0),
        name='schema-swagger-ui'),
    url(r'^redoc/$',
        SchemaView.with_ui('redoc', cache_timeout=0),
        name='schema-redoc'),
    url(r'^redoc-old/$',
        SchemaView.with_ui('redoc-old', cache_timeout=0),
        name='schema-redoc-old'),
    url(r'^cached/swagger(?P<format>.json|.yaml)$',
        SchemaView.without_ui(cache_timeout=None),
        name='cschema-json'),
    url(r'^cached/swagger/$',
        SchemaView.with_ui('swagger', cache_timeout=None),
        name='cschema-swagger-ui'),
    url(r'^cached/redoc/$',
        SchemaView.with_ui('redoc', cache_timeout=None),
        name='cschema-redoc'),
    url(r'^$', root_redirect),
]

# urlpatterns += [url(r'^silk/', include('silk.urls', namespace='silk'))]
