import os
from qcloud_cos import CosConfig
from addict import Dict

BASE_DIR = os.path.dirname(
    os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

ROOT_URLCONF = "urls"

WSGI_APPLICATION = "etc.wsgi.wsgi"

SECRET_KEY = '=y-!a%%@j@u7@4dx%1xii$+rrqory&%nnpo&ciyw_d_g^qmf39'

ALLOWED_HOSTS = ['*']

# DEBUG = os.environ.get("DJANGO_DEBUG", False)

LANGUAGE_CODE = 'en-us'

TIME_ZONE = "Asia/Shanghai"

USE_I18N = True

USE_L10N = True

USE_TZ = True

LOG_PATH = os.path.join(os.path.dirname(BASE_DIR), "logs")
if not os.path.exists(LOG_PATH):
    os.makedirs(LOG_PATH)
DEFAULT_HANDLERS = ['file_handler', 'console']

# OPEN_SILK = os.environ.get("OPEN_SILK", False)
# SILKY_PYTHON_PROFILER_RESULT_PATH = os.path.join(LOG_PATH, "silky_logs")
# SILKY_PYTHON_PROFILER = True
# SILKY_PYTHON_PROFILER_BINARY = True
# if not os.path.exists(SILKY_PYTHON_PROFILER_RESULT_PATH):
#     os.makedirs(SILKY_PYTHON_PROFILER_RESULT_PATH)

UPLOAD_FILE_PATH = os.path.join(os.path.dirname(BASE_DIR), "files")
if not os.path.exists(UPLOAD_FILE_PATH):
    os.makedirs(UPLOAD_FILE_PATH)
EXPORT_ROOT = os.path.join(BASE_DIR, "export")
EXPORT_URL = "/export/"
if not os.path.exists(EXPORT_ROOT):
    os.makedirs(EXPORT_ROOT)

HOST_NAME = os.environ.get('HOST_NAME', 'http://127.0.0.1')
HOST_PORT = os.environ.get('HOST_PORT', '8000')

NAME_ID_LENGTH = 12
VERSION = 'v1'
AUTH_USER_MODEL = "accounts.Accounts"
LOGIN_REDIRECT_URL = "/"
LOGIN_URL = "/api/v1/login"
LOGOUT_URL = "/api/v1/logout"
FILE_URL = "/api/v1/export"
UPLOAD_URL = "/api/v1/upload"
USERNAME = 'admin'
PASSWORD = 'afafa'
ENTERPRISE_NAME = '电管家（上海）'

CLOUD_COS = Dict({
    "COS_SECRET_ID": "AKIDxf6UdVGoRtL0RdRYQGdr20iBOMlvZvjx",
    "COS_SECRET_KEY": "6vPcavztZy75nQmfgU3NmunT2Q3TfdPY",
    "COS_REGION": "ap-shanghai",
    "TOKEN": None,
    "SCHEME": "https",
    "PROXIES": {},
    # 图片存放
    "IMAGE_BUCKET": "images-1302976931",
    # 文件存放
    "UPLOAD_BUCKET": "upload-1302976931",
    # excel表格存放
    "EXCEL_BUCKET": "excel-1302976931",
    # 监控审批单存放
    "MONITOR_RECORD_BUCKET": "monitor-record-images-1302976931",
})
WECHAT_BOT = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=34fa3fc2-5984-464d-b5b4-4789dcfc87a5"
Q_CLOUD_CONFIG = CosConfig(Region=CLOUD_COS.COS_REGION,
                           SecretId=CLOUD_COS.COS_SECRET_ID,
                           SecretKey=CLOUD_COS.COS_SECRET_KEY,
                           Token=CLOUD_COS.TOKEN,
                           Scheme=CLOUD_COS.SCHEME)
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

STATIC_ROOT = os.path.join(BASE_DIR, 'static')
# https://docs.djangoproject.com/en/dev/ref/settings/#static-url
STATIC_URL = "/static/"

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, '/static/'),
]

# 消息类型 1 系统通知 2 任务 3 巡检任务 4 监控告警
MESSAGE_TYPE = ["1", "2", "3", "4"]

BRANCH_ENTIDS = '(75,76,80,52,49,6,29,30,36,20,54,28,70,26,77,23,' \
                '19,31,32,33,34,35,37,43,44,45,46,47,48,53,41,39,' \
                '40,42,50,27,25,78,24,23)'

BRANCH_ENT = [
    {
        "id": 1,
        "name": "电管家集团有限公司"
    },
    {
        "id": 6,
        "name": "电管家奉贤分公司"
    },
    {
        "id": 49,
        "name": "电管家苏州分公司"
    },
    {
        "id": 52,
        "name": "电管家三亚分公司"
    },
    {
        "id": 54,
        "name": "电管家福建分公司"
    },
    {
        "id": 70,
        "name": "电管家金山分公司"
    }
]

MOCK_NUMBER = [90037, 90038, 90039, 90040]
