from django.urls import path

from crm.plan import views

urlpatterns = [
    path("/create", views.CreatePlanView.as_view()),
    path("", views.PlanInfoView.as_view()),
    path("/<int:id>", views.PlanInfoView.as_view()),
    path("/<int:id>/edit", views.UpdatePlanView.as_view()),
    path("/<int:id>/delete", views.DeletePlanView.as_view()),
    path("/customer_clue/create", views.CreateCustomerClueView.as_view()),
    path("/create_task", views.CreateTaskView.as_view()),
    path("/task/<int:id>/update", views.UpdateTaskView.as_view()),
    path("/tasks", views.TaskListView.as_view()),
    path("/task/<int:id>", views.TaskListView.as_view()),
    path("/task/<int:id>/approve", views.TaskApproveView.as_view()),
    path("/clock_in", views.SignInView.as_view()),
    path("/<int:id>/contract", views.PlanContractView.as_view()),
    path("/<int:id>/urge", views.TaskUrgeView.as_view()),
    path("/create_message", views.MessageView.as_view()),
    path("/sign_in", views.SignInListView.as_view())

]
