from django.db import models

# Create your models here.
from common.utils.models import BaseModel

from crm.crm_customer.models import CrmCustomer

from console.contract.models import Contract

from common.accounts.models import Users

from common.accounts.models import Accounts


class Plan(BaseModel):
    name = models.CharField(max_length=32, null=True, help_text="名称")
    customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL,
                                 null=True, help_text="所属客户")
    type = models.CharField(max_length=32, null=True, help_text="计划类型")
    contract = models.ForeignKey(to=Contract, on_delete=models.SET_NULL,
                                 null=True, help_text="关联合同")
    status = models.CharField(max_length=16, null=True, help_text="状态")
    recent_code = models.IntegerField(null=True, help_text="当前节点")
    start_time = models.DateTimeField(null=True, help_text="开始时间")

    end_time = models.DateTimeField(null=True, help_text="结束时间")
    creater = models.ForeignKey(to=Users, on_delete=models.SET_NULL,
                                null=True, related_name="plan_user")

    class Meta:
        db_table = "crm_plan"


class Code(BaseModel):
    name = models.CharField(max_length=32, help_text="节点名")

    class Meta:
        db_table = "crm_code"


class PlanCode(BaseModel):
    plan = models.ForeignKey(to=Plan, on_delete=models.SET_NULL, null=True, help_text="所属计划")
    code = models.ForeignKey(to=Code, on_delete=models.SET_NULL, null=True, help_text="所属节点")
    index = models.IntegerField(default=1, help_text="顺序")
    duration = models.IntegerField(default=0, help_text="时长，单位为d")
    file = models.CharField(max_length=256, null=True, help_text="附件")
    status = models.CharField(max_length=16, null=True, help_text="状态")

    class Meta:
        db_table = "crm_plan_code"


class CustomerOperationRecord(BaseModel):
    customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    plan = models.ForeignKey(to=Plan, on_delete=models.SET_NULL, null=True, help_text="所属计划")
    content = models.CharField(max_length=64, null=True, help_text="内容")
    account = models.ForeignKey(to=Accounts, on_delete=models.SET_NULL, null=True)

    class Meta:
        db_table = "crm_customer_operation_record"


class CrmTask(BaseModel):
    type = models.CharField(max_length=16, null=True, help_text="任务类型")
    code = models.ForeignKey(to=Code, on_delete=models.SET_NULL, null=True, help_text="所属节点")
    status = models.CharField(max_length=16, null=True, help_text="状态")
    remark = models.CharField(max_length=32, null=True, help_text="备注")
    customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    plan = models.ForeignKey(to=Plan, on_delete=models.SET_NULL, null=True, help_text="所属计划")
    intention = models.BooleanField(null=True, help_text="客户意向")
    urgent = models.BooleanField(null=True, default=False, help_text="是否加急/催办")
    submitter = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="提交人")
    file = models.CharField(max_length=256, null=True, help_text="文件")
    contact = models.TextField(null=True, help_text="客户联系人")
    ele_user = models.TextField(null=True, help_text="户号")
    approval_status = models.CharField(max_length=16, null=True, help_text="审批状态")
    amount = models.FloatField(null=True)
    finish_time = models.DateTimeField(null=True, help_text="完成时间")
    contract_id = models.CharField(max_length=32, null=True, help_text="合同id")

    class Meta:
        db_table = "crm_task"


class TaskApprovalRecord(BaseModel):
    task = models.ForeignKey(to=CrmTask, on_delete=models.SET_NULL, null=True, help_text="所属任务")
    result = models.CharField(max_length=16, null=True, help_text="审批结果")
    remark = models.CharField(max_length=256, null=True, help_text="审批理由")
    reviewer = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="审批人")

    class Meta:
        db_table = "crm_task_approval_record"


class SignIn(BaseModel):
    user = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="人员")
    address = models.CharField(max_length=64, null=True, help_text="地址")
    customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    time = models.DateTimeField(null=True, help_text="打卡时间")
    file = models.CharField(max_length=128, help_text="文件", null=True)
    remark = models.CharField(max_length=128, null=True, help_text="备注")

    class Meta:
        db_table = "crm_sign_in"


class VisitRecord(BaseModel):
    customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    user = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="拜访者")
    content = models.CharField(max_length=64, null=True, help_text="内容")
    visit_time = models.DateTimeField(null=True, help_text="拜访时间")
    remark = models.CharField(max_length=128, null=True, help_text="备注")

    class Meta:
        db_table = "crm_customer_visit"


class Message(BaseModel):
    title = models.CharField(max_length=32, null=True, help_text="标题")
    content = models.CharField(max_length=256, null=True, help_text="内容")
    creater = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="创建人")
    customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    limit_time = models.DateTimeField(null=True, help_text="截止跟进时间")
    plan = models.ForeignKey(to=Plan, on_delete=models.SET_NULL, null=True, help_text="所属计划")
    type = models.CharField(max_length=16, help_text="消息类型")
    task = models.ForeignKey(to=CrmTask, on_delete=models.SET_NULL, null=True)
    contact = models.CharField(max_length=32, null=True, help_text="客户联系人")
    contact_phone = models.CharField(max_length=32, null=True, help_text="客户联系人电话")
    status = models.BooleanField(null=True, default=False, help_text="处理状态")

    class Meta:
        db_table = "crm_message"


class UserMessage(BaseModel):
    message = models.ForeignKey(to=Message, on_delete=models.SET_NULL, null=True, help_text="所属消息")
    user = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="接受人",
                             related_name="message_user")
    status = models.CharField(max_length=16, null=True, help_text="状态")
    is_read = models.BooleanField(default=False, help_text="是否已读")

    class Meta:
        db_table = "crm_user_message"
