import json
import logging

from django.db.transaction import atomic
from common.utils.models import BaseConnection
from common.utils.exceptions import ValidationError
from crm.crm_users.repositories import crm_user_repo
from crm.crm_customer.models import CustomerClue

logger = logging.getLogger("")
base_db = BaseConnection()


class CrmUserService(object):
    def get_users(self, enterprise_id, **kwargs):
        return crm_user_repo.get_users(enterprise_id, **kwargs)

    def get_users_simple(self, enterprise_id, **kwargs):
        return crm_user_repo.get_users_simple(enterprise_id, **kwargs)

    def get_user_info(self, enterprise_id, user_id):
        return crm_user_repo.get_user_info(enterprise_id, user_id)

    def delete_user(self, enterprise_id, user_id):
        return crm_user_repo.delete_user(enterprise_id, user_id)

    def import_users(self, enterprise_id, user_list):
        return crm_user_repo.import_users(enterprise_id, user_list)


crm_user_service = CrmUserService()
