import datetime
import time

from common.utils.views import BaseApiView
from rest_framework.response import Response

from common.utils.return_structure import general_message

from crm.crm_statistic.services import StatisticService


class ConversionView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        type = request.GET.get("type")
        start_time = request.GET.get("start_time")
        end_time = request.GET.get("end_time")
        user_id = request.GET.get("user_id")
        data = {
            "customer_clue_number": service.get_customer_clue_number(**{
                "type": type,
                "user_id": user_id,
                "start_time": start_time,
                "end_time": end_time
            }),
            "visit_customer_number": service.get_visit_customer_number(**{
                "type": type,
                "user_id": user_id,
                "start_time": start_time,
                "end_time": end_time
            }),
            "scheme_number": service.get_scheme_number(**{
                "type": type,
                "user_id": user_id,
                "start_time": start_time,
                "end_time": end_time
            }),
            "contract_number": service.get_contract_number(**{
                "type": type,
                "user_id": user_id,
                "start_time": start_time,
                "end_time": end_time
            })
        }
        return Response(general_message(bean=data))


class PersonTaskNumberView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        return Response(general_message(bean=service.person_task_statictis(self.user.id)))


class PersonAchievementsView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        year_month = request.GET.get("year_month")
        if not year_month:
            year_month = "{}-{}".format(datetime.datetime.now().year, datetime.datetime.now().month)
        return Response(general_message(bean=service.person_achievement(self.user.id, year_month)))


class ContractTrendView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        type = request.GET.get("type")
        start_time = request.GET.get("start_time")
        end_time = request.GET.get("end_time")
        data = {
            "sign_contract_status": service.get_sign_contract_status(**{
                "type": type,
                "start_time": start_time,
                "end_time": end_time
            }),
            "person_rank": service.get_person_ranking(**{
                "type": type,
                "start_time": start_time,
                "end_time": end_time
            })
        }
        return Response(general_message(bean=data))


class ContractStatusView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        return Response(general_message(
            bean={
                "contract_amount_status": service.get_contract_amount(),
                "contract_number_status": service.get_contract_status()
            }
        ))


class AmountTrendView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        type = request.GET.get("type")
        start_time = request.GET.get("start_time")
        end_time = request.GET.get("end_time")
        return Response(general_message(
            bean={
                "amount": service.amount_statistic(**{
                    "type": type,
                    "start_time": start_time,
                    "end_time": end_time
                }),
                "rank": service.person_amount_rank(**{
                    "type": type,
                    "start_time": start_time,
                    "end_time": end_time
                })
            }
        ))


class AreaIndustryAmountView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        return Response(general_message(
            bean={
                "area_amount": service.area_amount(),
                "industry_amount": service.industry_amount()
            }
        ))


class CustomerClueNumberView(BaseApiView):

    def get(self, request, *args, **kwargs):
        service = StatisticService()
        return Response(general_message(
            bean=service.clue_number_statistic()
        ))


class CustomerClueStatisticView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        type = request.GET.get("type")
        start_time = request.GET.get("start_time")
        end_time = request.GET.get("end_time")
        return Response(general_message(bean={
            "clue_statis": service.clue_statistic(**{
                "type": type,
                "start_time": start_time,
                "end_time": end_time
            }),
            "person_rank": service.person_clue_rank(**{
                "type": type,
                "start_time": start_time,
                "end_time": end_time
            })
        }))
