from django.db import models

# Create your models here.
from common.utils.models import BaseModel

from console.customer.models import Customer

from common.accounts.models import Users, Enterprise


class CrmCustomer(BaseModel):
    customer = models.ForeignKey(to=Customer, on_delete=models.SET_NULL,
                                 null=True, help_text="所属客户")
    # 0 低价值客户 1 中价值客户 2 高价值客户
    level = models.IntegerField(default=0, null=True, help_text="客户等级")
    salesman = models.ForeignKey(to=Users, on_delete=models.SET_NULL,
                                 null=True, help_text="销售")
    # 0 未分配 1 已分配
    status = models.IntegerField(default=0, null=True, help_text="状态")
    # 0 新客户 2老客户
    type = models.IntegerField(default=0, null=True, help_text="")
    # 0 没有意向 1 有意向
    intention = models.BooleanField(default=1, null=True, help_text="客户意向")
    comments = models.CharField(max_length=1024, null=True, help_text="备注")
    month_epi = models.FloatField(null=True, help_text="月用电量")
    ele_info = models.CharField(max_length=2048, null=True, help_text="用电信息")
    is_sign = models.BooleanField(default=False, help_text="是否已签约")

    class Meta:
        db_table = "crm_customer"


class CustomerRemark(BaseModel):
    crm_customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    content = models.CharField(max_length=256, null=True, help_text="备注内容")
    user = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="备注用户")

    class Meta:
        db_table = "crm_customer_remark"


class CustomerClue(BaseModel):
    crm_customer = models.ForeignKey(to=CrmCustomer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    customer = models.ForeignKey(to=Customer, on_delete=models.SET_NULL, null=True, help_text="所属客户")
    enterprise = models.ForeignKey(to=Enterprise, on_delete=models.SET_NULL, null=True, help_text="所属公司")
    salesman = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="业务员",
                                 related_name="salemen")
    inputer = models.ForeignKey(to=Users, on_delete=models.SET_NULL,
                                null=True, help_text="录入者", related_name="inputer")
    # 0 待审批 1 已审批
    status = models.IntegerField(default=0, help_text="状态")
    name = models.CharField(max_length=128, help_text="名称")
    address = models.CharField(max_length=128, help_text="地址")
    # 0 低价值客户 1 中价值客户 2 高价值客户
    level = models.IntegerField(default=0, help_text="客户等级")
    longitude = models.CharField(max_length=16, help_text="经度")
    latitude = models.CharField(max_length=16, help_text="纬度")
    adcode = models.CharField(max_length=16, help_text="省级编码")
    city_code = models.CharField(max_length=16, help_text="城市编码")
    district = models.CharField(max_length=16, help_text="区县编码")
    ele_user_count = models.IntegerField(default=0, help_text="户号数")
    content = models.TextField(help_text="客户线索")

    class Meta:
        db_table = "crm_customer_clue"


class CrmCustomerTags(BaseModel):
    tag_id = models.IntegerField(help_text="客户标签")
    crm_customer_id = models.IntegerField(help_text="客户id")

    class Meta:
        db_table = "crm_customer_tags"


class CustomerClueTags(BaseModel):
    tag_id = models.IntegerField(help_text="客户标签")
    crm_customer_clue_id = models.IntegerField(help_text="客户线索id")

    class Meta:
        db_table = "crm_customer_clue_tags"


class CrmCustomerTagsMap(BaseModel):
    name = models.CharField(max_length=64, help_text="标签名称")

    class Meta:
        db_table = "crm_customer_tags_map"
