from rest_framework import serializers as serializer

from console.powerstation.models import PowerStation
from console.task.models import Task


class StatisticSerializer(serializer.ModelSerializer):
    task_stattistic = serializer.SerializerMethodField()
    monitor_statistic = serializer.SerializerMethodField()

    def get_monitor_statistic(self, obj):
        return {"alarm_repair": 0, "alarm_total": 0}

    def get_task_stattistic(self, obj):
        tasks = Task.objects.filter(station=obj, type="rush_to_repair")

        return {
            "repair_total": tasks.count(),
            "repair_completed": tasks.filter(status="completed").count()
        }

    class Meta:
        model = PowerStation
        fields = ("status", "task_stattistic", "monitor_statistic")
