import time

from django.db import transaction
from .models import Team, TeamSchedule


class TeamService(object):
    @transaction.atomic()
    def delete_team(self, pks, enterprise_id):
        teams = Team.objects.filter(id__in=pks,
                                    enterprise_id__in=enterprise_id)
        for team in teams:
            team.member.clear()
        teams.update(deleted=True,
                     deleted_time=time.strftime("%Y-%m-%d %H:%M:%S",
                                                time.localtime()))


class TeamScheduleService(object):
    @transaction.atomic()
    def delete_team(self, team, schedule_date):
        TeamSchedule.objects.filter(
            deleted=False,
            team=team,
            schedule_date__year=schedule_date.tm_year,
            schedule_date__month=schedule_date.tm_mon).update(
                deleted=True,
                deleted_time=time.strftime("%Y-%m-%d %H:%M:%S",
                                           time.localtime()))

    @transaction.atomic()
    def delete_team_schedule(self, team, schedule_date):
        TeamSchedule.objects.filter(
            deleted=False,
            team_id=team,
            schedule_date__year=schedule_date.tm_year,
            schedule_date__month=schedule_date.tm_mon).update(
                deleted=True,
                deleted_time=time.strftime("%Y-%m-%d %H:%M:%S",
                                           time.localtime()))


team_service = TeamService()
team_schedule_service = TeamScheduleService()
