from django.db import models
from common.utils.models import BaseModel
from common.accounts.models import Users, Enterprise

# Create your models here.
TEAM_TYPE = (("0", "调度"), ("1", "值班"), ("2", "巡检"), ("3", "抢修"), ("4", "共享电工"))
HANDOVER_TYPE = (("0", "调度"), ("1", "值班"))


class Team(BaseModel):
    id = models.AutoField(primary_key=True)
    name = models.CharField(max_length=32,
                            null=False,
                            blank=False,
                            help_text="班组名称")

    team_headman = models.ForeignKey(to=Users,
                                     related_name='team_head_user',
                                     on_delete=models.SET_NULL,
                                     null=True,
                                     help_text="组长")
    member = models.ManyToManyField(to=Users, help_text="组员", null=True)

    type = models.CharField(max_length=32,
                            choices=TEAM_TYPE,
                            null=False,
                            help_text="班组类型")
    car_number = models.CharField(max_length=16,
                                  null=False,
                                  blank=False,
                                  help_text="车牌号")
    leader = models.ForeignKey(to=Users,
                               related_name='leader_user',
                               on_delete=models.SET_NULL,
                               null=True,
                               blank=True,
                               help_text="区块链经理")
    enterprise = models.ForeignKey(to=Enterprise,
                                   related_name='ent_team',
                                   on_delete=models.SET_NULL,
                                   null=True,
                                   help_text="所属公司")

    class Meta:
        db_table = 'team'

    def __str__(self):
        return self.name

    @property
    def get_type(self):
        return self.get_type_display()


class TeamSchedule(BaseModel):
    id = models.AutoField(primary_key=True)
    team = models.ForeignKey(to=Team,
                             on_delete=models.SET_NULL,
                             null=True,
                             help_text="排班计划")
    schedule_date = models.DateField()

    class Meta:
        db_table = 'team_schedule'


class HandOverRecord(BaseModel):
    id = models.AutoField(primary_key=True)
    station = models.CharField(max_length=32,
                               null=True,
                               blank=True,
                               help_text="值班站")
    transfer_team = models.ForeignKey(to=Team,
                                      related_name='tarnsefer_team_name',
                                      on_delete=models.SET_NULL,
                                      null=True,
                                      help_text="交班班组")
    recieve_team = models.ForeignKey(to=Team,
                                     related_name='recieve_team_name',
                                     on_delete=models.SET_NULL,
                                     null=True,
                                     help_text="接班班组")
    handover_time = models.DateTimeField(help_text="交接班时间")

    type = models.CharField(max_length=16,
                            choices=HANDOVER_TYPE,
                            null=False,
                            blank=False,
                            help_text="交接班类型")
    inspect = models.TextField(null=True, blank=True, help_text="检查情况")
    changes = models.CharField(max_length=256,
                               null=True,
                               blank=True,
                               help_text="当值电系变动情况")
    overhaul = models.CharField(max_length=256,
                                null=True,
                                blank=True,
                                help_text="当值电系变动情况")
    work_situation = models.CharField(max_length=32,
                                      null=True,
                                      blank=True,
                                      help_text="操作详情")
    equipment_inspect = models.CharField(max_length=256,
                                         null=True,
                                         blank=True,
                                         help_text="当前设备检查情况")
    station_work = models.CharField(max_length=256,
                                    null=True,
                                    blank=True,
                                    help_text="站务工作")
    work_ticket = models.CharField(max_length=32,
                                   null=True,
                                   blank=True,
                                   help_text="工作票情况")
    handover_work = models.CharField(max_length=256,
                                     null=True,
                                     blank=True,
                                     help_text="交接给下一班的工作")
    tool_check = models.CharField(max_length=32,
                                  null=True,
                                  blank=True,
                                  help_text="工具检查情况")
    other = models.TextField(null=True, blank=True, help_text="其他事项")
    dispatch_options = models.CharField(max_length=64,
                                        null=True,
                                        blank=True,
                                        help_text="调度交接班选项")

    class Meta:
        db_table = 'hand_over_record'
