from django.urls import path
from console.task import views

urlpatterns = [
    path("", views.TaskCreateView.as_view()),
    path("/tasks", views.TaskListView.as_view()),
    path("/order", views.OrderCreateView.as_view()),
    path("/<int:id>/contract", views.TaskRelateContract.as_view()),
    path("/<int:id>", views.TaskCloseView.as_view(), name="task_close"),
    path("/<int:id>/info", views.TaskInfoView.as_view(), name="task_info"),
    path("/<int:id>/plan_date", views.TaskPlanDateView.as_view()),
    path("/<int:id>/check_plan", views.TaskPlanCheckView.as_view()),
    path("/<int:id>/confirm", views.TaskConfirmView.as_view()),
    path("/customers", views.TaskCreateCustomerListView.as_view()),
    path("/customer/<int:id>", views.TaskCreateCustomerInfoView.as_view()),
    path("/export", views.TaskExportView.as_view()),
    path("/<int:id>/edit", views.TaskEditView.as_view()),
    path("/<int:id>/evaluate", views.TaskEvaluateView.as_view())
]
