from django.db import models

# Create your models here.
from common.utils.models import BaseModel
from console.customer.models import Customer
from console.equipment.models import Equipment
from console.powerstation.models import PowerStation
from console.contract.models import Contract


class Task(BaseModel):
    name = models.CharField(max_length=32, help_text="名称")
    customer = models.ForeignKey(to=Customer,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 help_text="客户")
    ele_user = models.CharField(max_length=16, null=True, help_text="户号id")
    station = models.ForeignKey(to=PowerStation,
                                on_delete=models.SET_NULL,
                                null=True,
                                help_text="电站")
    equipment = models.ForeignKey(to=Equipment,
                                  on_delete=models.SET_NULL,
                                  null=True,
                                  help_text="设备")
    type = models.CharField(max_length=32, help_text="任务类型")
    subtype = models.CharField(max_length=32, help_text="任务子类型", null=True)
    status = models.CharField(max_length=32, help_text="状态")
    reason = models.CharField(max_length=256, null=True, help_text="原因")
    describe = models.TextField(help_text="任务描述", null=True)
    contacts = models.CharField(max_length=32, help_text="联系人", null=True)
    contacts_phone = models.CharField(max_length=32,
                                      help_text="联系人电话",
                                      null=True)
    addr = models.CharField(max_length=256, null=True, help_text="地址")
    is_cost = models.BooleanField(default=False, help_text="是否产生费用")
    finish_time = models.DateTimeField(null=True, help_text="完成时间")
    contract = models.ForeignKey(to=Contract,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 help_text="关联合同")
    file = models.TextField(null=True, help_text="图片url")
    finished_tag = models.BooleanField(default=False, help_text="任务完成标记")
    confirm = models.BooleanField(default=False, help_text="客户确认状态")
    number = models.CharField(max_length=32,
                              null=True,
                              help_text="任务编号",
                              unique=True)
    plan_date = models.DateTimeField(null=True, help_text="计划排期")
    remarks = models.TextField(null=True, help_text="备注")
    location = models.CharField(max_length=64, null=True, help_text="坐标")
    dispatcher = models.CharField(max_length=32, null=True, help_text="值班调度")
    source = models.CharField(max_length=32, null=True, help_text="来源")
    score = models.FloatField(null=True, help_text="客户评分")
    appraise = models.CharField(max_length=256, null=True, help_text="客户评价")
    appraise_time = models.DateTimeField(null=True)

    class Meta:
        db_table = "task"


class SerialNumber(BaseModel):
    number = models.IntegerField(default=1, help_text="流水号")
    last_number = models.IntegerField(null=True, help_text="上一个流水号")

    class Meta:
        db_table = "serial_number"


class WorkLog(BaseModel):
    task = models.ForeignKey(to=Task,
                             on_delete=models.SET_NULL,
                             null=True,
                             help_text="所属任务")
    content = models.TextField(null=True, help_text="日志内容")

    class Meta:
        db_table = "work_log"
