#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.urls import path

from . import views

urlpatterns = [
    path("", views.PowerStationView.as_view()),
    path("<int:id>", views.PowerStationView.as_view()),
    path("file", views.PowerStationFileView.as_view()),
    path("outline", views.OutlineView.as_view()),
    path("outline/<int:id>", views.OutlineView.as_view()),
    path("<int:power_station_id>/circuit", views.CircuitLCView.as_view()),
    path("<int:power_station_id>/circuit/<int:circuit_id>",
         views.CircuitRUDView.as_view()),
    path("<int:station_id>/monitor/points", views.StationMonitorPointsLView.as_view()),
]
