#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django_filters import rest_framework as filters

from console.monitor.models import MonitorPoints


class MonitorPointsLFilter(filters.FilterSet):
    name = filters.CharFilter(field_name='name',
                              label='name',
                              lookup_expr='contains',
                              help_text='通过名称查找')
    equipment_id = filters.CharFilter(method="get_equipment_id")
    electricity_user_id = filters.CharFilter(method="get_electricity_user_id")
    customer_id = filters.CharFilter(method="get_customer_id")
    station_id = filters.CharFilter(method="get_station_id")

    def get_equipment_id(self, queryset, _, value):
        queryset = queryset.filter(equipment_id=value)
        return queryset

    def get_electricity_user_id(self, queryset, _, value):
        queryset = queryset.filter(electricity_user_id=value)
        return queryset

    def get_customer_id(self, queryset, _, value):
        queryset = queryset.filter(customer_id=value)
        return queryset

    def get_station_id(self, queryset, _, value):
        queryset = queryset.filter(station_id=value)
        return queryset

    class Meta:
        model = MonitorPoints
        fields = ('id', 'name', 'customer_id', 'electricity_user_id',
                  'equipment_id', 'station_id', 'status')
