from rest_framework import status
from rest_framework.response import Response
from django.views.decorators.gzip import gzip_page
from django.utils.decorators import method_decorator

from common.utils.return_structure import general_message
from common.utils.views import BaseApiView

from console.message.models import MessagesDispatcher
from console.message.services import msg_service


class MessageLView(BaseApiView):
    def get(self, request, *args, **kwargs):
        id = kwargs.get('message_id')
        query = request.GET.copy()
        page = query.get("page", 1)
        page_size = query.get("page_size", 10)
        query.update({"page": page, "page_size": page_size})
        if id:
            query.update({"id": str(id)})
        # config = msg_service.get_user_message_config()
        customers_info, count = msg_service.get_messages(
             self.enterprise_ids, self.user.id, **query)
        if id:
            data = general_message(bean=customers_info[0])
        else:
            data = general_message(list=customers_info, count=count, page=page, page_size=page_size)
        return Response(data, status=status.HTTP_200_OK)

    def delete(self, request, message_id, *args, **kwargs):
        MessagesDispatcher.objects.filter(
            message_id=message_id, receive_id=self.user.id).update(deleted=1)
        return Response(general_message(), status=status.HTTP_200_OK)


@method_decorator(gzip_page, name='dispatch')
class PersonMessageLView(BaseApiView):
    def get(self, request, *args, **kwargs):
        query = request.GET.copy()
        query.update({"_sort":"-created_time"})
        config = msg_service.get_user_message_config()
        messages, count = msg_service.get_messages(
            self.enterprise_ids, self.user.id, config, True, **query)
        data = general_message(list=messages, count=count)
        return Response(data, status=status.HTTP_200_OK)

    def put(self, request, message_id, *args, **kwargs):
        MessagesDispatcher.objects.filter(
            id=message_id, receive_id=self.user.id).update(is_read=1)
        return Response(general_message(), status=status.HTTP_200_OK)

    def delete(self, request, message_id, *args, **kwargs):
        MessagesDispatcher.objects.filter(
            message_id=message_id, receive_id=self.user.id).update(deleted=1)
        return Response(general_message(), status=status.HTTP_200_OK)


class PersonMessageNopopView(BaseApiView):
    def put(self, request, message_id, *args, **kwargs):
        MessagesDispatcher.objects.filter(
            id=message_id, receive_id=self.user.id).update(is_pop=0)
        return Response(general_message(), status=status.HTTP_200_OK)


class MessageNopopView(BaseApiView):
    def put(self, request, *args, **kwargs):
        MessagesDispatcher.objects.filter(receive_id=self.user.id).update(is_pop=0)
        return Response(general_message(), status=status.HTTP_200_OK)


class PersonMessageReadAllView(BaseApiView):
    def put(self, request, *args, **kwargs):
        MessagesDispatcher.objects.filter(is_read=0, receive_id=self.user.id).update(is_read=1)
        return Response(general_message(), status=status.HTTP_200_OK)
