from django.db import models

from common.utils.models import BaseModel
from common.accounts.models import Users, Accounts

from notifications.base.models import AbstractNotification


class Message(BaseModel):
    title = models.CharField(max_length=32, null=True, help_text="标题")
    content = models.CharField(max_length=1024, help_text="消息内容")
    sender = models.ForeignKey(to=Accounts,
                               on_delete=models.SET_NULL,
                               null=True,
                               help_text="发送人",
                               related_name="sender",
                               db_column="sender")
    SEND_TYPE = ((0, "SMS"), (1, "email"), (2, "application"))
    send_type = models.CharField(max_length=32,
                                 choices=SEND_TYPE,
                                 default=2,
                                 help_text="发送类型")
    type = models.CharField(max_length=32, null=True, help_text="消息类型")

    class Meta:
        db_table = "message"


class UserMessage(BaseModel):
    user = models.ForeignKey(to=Users,
                             on_delete=models.SET_NULL,
                             null=True,
                             help_text="用户")
    message = models.ForeignKey(to=Message,
                                on_delete=models.SET_NULL,
                                null=True,
                                help_text="消息")

    class Meta:
        db_table = "user_message"


class Notifications(AbstractNotification):
    is_pop = models.BooleanField(default=False)
    type = models.CharField(max_length=32, null=True)

    class Meta(AbstractNotification.Meta):
        db_table = "notification"


class Messages(BaseModel):
    enterprise_id = models.IntegerField(help_text="公司")
    title = models.CharField(max_length=64, help_text="标题")
    content = models.CharField(max_length=1024, help_text="消息体")
    # 渲染类型 1 text 2 html 3 markdown
    render_type = models.IntegerField(help_text="渲染方式")
    sender_id = models.IntegerField(help_text="发送人")
    # 消息类型 1 系统通知 2 任务 3 巡检任务 4 监控告警
    type = models.IntegerField(help_text="消息类型")
    links = models.CharField(max_length=256, help_text="超链接")
    class Meta:
        db_table = "messages"


class MessagesDispatcher(BaseModel):
    receive_id = models.IntegerField(help_text="渲染方式")
    receive_status = models.IntegerField(default=True, help_text="接收状态")
    message_id = models.IntegerField(help_text="消息id")
    is_read = models.BooleanField(default=False, help_text="阅读状态")
    is_pop = models.BooleanField(default=True, help_text="是否弹窗")
    class Meta:
        db_table = "messages_dispatcher"


class UserMessageConfig(BaseModel):
    user_id = models.IntegerField(help_text="渲染方式")
    # 消息类型 1 系统通知 2 任务 3 巡检任务 4 监控告警
    type = models.IntegerField(help_text="类型")
    config = models.IntegerField(help_text="配置")
    is_stop = models.BooleanField(default=False, help_text="是否停用")
    class Meta:
        db_table = "user_message_config"
