#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.urls import path
from console.learningcenter import views

urlpatterns = [
    path("knowledge/", views.KnowledgeLDView.as_view()),  # 知识点列表
    path("knowledge/<int:id>", views.KnowledgeLDView.as_view()),  # 知识点列表删除

    # 知识点详情与创建页面
    path("knowledge/detail/", views.KnowledgeCreateView.as_view()),

    # 知识库列表与创建
    path('warehouse/', views.KnowledgeRepositoryLDView.as_view()),
    path('warehouse/<int:id>',
         views.KnowledgeRepositoryLDView.as_view()),  # 删除

    # 小程序获取知识点列表
    path('program/knowledge/', views.MiniKnowledgeLView.as_view()),

    # 小程序获取知识库列表
    path('program/warehouse/', views.MiniKnowledgeRepositoryLView.as_view()),

    # 小程序获取新闻列表
    path('program/news/', views.MiniNewsLView.as_view()),

    # 小程序获取知识点/新闻详情
    path('program/detail/', views.MiniKnowledgeView.as_view()),
]
