from django.db import models

from common.utils.models import BaseModel


# Create your models here.
class KnowledgeRepository(BaseModel):
    name = models.CharField(max_length=128,
                            unique=True,
                            null=False,
                            blank=False,
                            help_text='标题')
    is_hot = models.BooleanField(default=False, help_text='是否推荐到首页')
    operator = models.CharField(max_length=20,
                                null=True,
                                blank=True,
                                help_text='发布人')

    class Meta:
        db_table = "learningcenter_knowledgerepository"


class KnowledgePoint(BaseModel):
    id = models.AutoField(primary_key=True)
    title = models.CharField(max_length=128,
                             null=False,
                             blank=False,
                             help_text='标题')
    abstract = models.CharField(max_length=256,
                                null=True,
                                blank=True,
                                help_text='摘要')
    text = models.TextField(null=False, blank=False, help_text='知识点内容')

    knowledge_type = models.CharField(max_length=16,
                                      null=False,
                                      blank=False,
                                      choices=((1, '新闻'), (2, '知识点')),
                                      help_text='类别')
    is_key_knowledge = models.BooleanField(default=False,
                                           null=True,
                                           help_text='是否关键知识点')
    knowledge_warehouse_type = models.ForeignKey(to=KnowledgeRepository,
                                                 on_delete=models.SET_NULL,
                                                 null=True,
                                                 help_text="知识库类别")
    cover_picture = models.CharField(max_length=256,
                                     null=True,
                                     blank=True,
                                     help_text='封面')
    visit_nums = models.IntegerField(default=1, help_text='阅读量')
    operator = models.CharField(max_length=20,
                                null=True,
                                blank=True,
                                help_text='发布人')

    class Meta:
        db_table = "learningcenter_knowledgepoint"
