from django.urls import path

from console.inspection import views

urlpatterns = [
    path("OMS/spect/plans", views.SpectionStation.as_view()),
    path("OMS/spect/plan", views.SpectPlanCreate.as_view()),
    path("OMS/spect/plan/stations", views.SpectPlanStation.as_view()),
    path("OMS/spect/plan/remove", views.InspectionPlanDelete.as_view()),
    path("OMS/spect/plan/change_plan", views.InspectionPlanUpdate.as_view()),
    path("OMS/spect/task/<int:id>/assign", views.SpectTaskAssign.as_view()),
    path("OMS/spect/task/<int:id>", views.SpectTaskInfo.as_view()),
    path("OMS/spect/task/<int:id>/confirm", views.TaskConfirmView.as_view()),
    path("OMS/spect/task", views.SpectionTask.as_view()),
    path("OMS/spect/record/<int:id>", views.SpectTaskRecord.as_view()),
    path("OMS/spect/defect", views.DefectList.as_view()),
    path("OMS/spect/defect/<int:id>/info", views.DefectInfo.as_view()),
    path("OMS/spect/defect/<int:id>", views.DefectHandle.as_view()),
    path("APP/spect/defect", views.DefectCreate.as_view()),
    path("APP/spect/data", views.SpectionDataCommit.as_view()),
    path("OMS/spect/task/<int:id>/arrive",
         views.InspectionTaskArrive.as_view()),
    path("OMS/spect/tasks/recent", views.InsepectionTaskRecent.as_view()),
    path("APP/defect/<int:id>", views.DefectUpdateView.as_view()),
    path("CMP/inspection/<int:id>", views.ConfirmView.as_view()),
    path("OMS/spect/task/export", views.TaskExportView.as_view()),
    path("OMS/spect/task/duty/<int:id>/info",
         views.InspectionTaskOfDayInfo.as_view()),
    path("OMS/spect/task/data_item", views.DataItemInfoView.as_view()),
    path("OMS/spect/task/duty/data_commit",
         views.DataItemCommitView.as_view()),
    path("OMS/spect/task/create", views.TaskCreateView.as_view()),
    path("OMS/spect/task/assign", views.TaskManyAssignView.as_view()),
    path("OMS/spect/date/plans", views.PlansOfDate.as_view()),
    path("OMS/spect/record/edit", views.UpdateInspectionDataView.as_view()),
    path("OMS/spect/defect/<int:id>/send_customer",
         views.DefectSendCustomer.as_view()),
    path("OMS/spect/export_report",
         views.ExportInspectionReportView.as_view()),
    path("OMS/spect/send_message", views.SendMessageToCustomer.as_view()),
    path("OMS/spect/report", views.PDFStreamView.as_view()),
    path("spect/last_month_power", views.LastMonthPowerDataView.as_view()),
    path("OMS/spect/defect/export", views.DefectExportView.as_view()),
    path("OMS/spect/safety_equipment", views.StationSafetyEquipmentView.as_view()),
    path("OMS/spect/report/send", views.ReportUploadView.as_view())
]
