#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django_filters import rest_framework as filters

from console.equipment.models import Equipment


class EquipmentFilter(filters.FilterSet):
    name = filters.CharFilter(
        field_name='id',
        label='id',
        # lookup_expr='contains',
        help_text='通过编号查找')

    class Meta:
        model = Equipment
        fields = '__all__'


class EquipmentListFilter(filters.FilterSet):
    customer = filters.CharFilter(method="get_customer")

    power_number = filters.CharFilter(method="get_power_number")

    def get_customer(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer__name__icontains=value)
        return queryset

    def get_power_number(self, queryset, name, value):
        if value:
            queryset = queryset.filter(electricity_user__number=value)
        return queryset
