import time

from django.db import transaction
from console.electricityuser.models import ElectricityUser
from console.powerstation.models import PowerStation


class electricityService(object):
    @transaction.atomic()
    def delete_electricty_user(self, pk):
        ElectricityUser.objects.filter(id__in=pk).update(
            deleted=True,
            deleted_time=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()))

        PowerStation.objects.filter(electricity_user_id__in=pk).update(
            deleted=True,
            deleted_time=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()))


electricity_service = electricityService()
