from rest_framework import serializers
from rest_framework.serializers import ModelSerializer, Serializer

from console.electrical_info.models import ElectricalInfromation

from console.powerstation.models import Outline


class ElectricalInfromationSerializer(ModelSerializer):
    """
    ElectricalInfromation Serializer
    """

    # powerstation = PrimaryKeyRelatedField
    # (queryset=PowerStation.objects.all())

    class Meta:
        model = ElectricalInfromation
        fields = ('id', 'power_number', 'meter_number', 'powerstation',
                  'incoming_line_name', 'comment', 'magnification',
                  'transformer_capacity', 'real_capacity', "voltage_level",
                  "ep_factor")

class ElectricalInfromationCSerializer(Serializer):
    power_number = serializers.CharField(max_length=32, help_text="电源编号")
    meter_number = serializers.CharField(max_length=32, help_text="电表号")
    powerstation = serializers.IntegerField(required=False, help_text="电站 id")
    incoming_line_name = serializers.CharField(max_length=64, help_text="电站 id")
    comment = serializers.CharField(max_length=1024, default=None, help_text="备注")
    magnification = serializers.FloatField(default=0, help_text="倍率")
    transformer_capacity = serializers.FloatField(default=0, help_text="变压器容量")
    real_capacity = serializers.FloatField(default=0, help_text="变压器实际容量")
    voltage_level = serializers.CharField(max_length=32, help_text="电压等级")
    ep_factor = serializers.CharField(max_length=32, default=0, help_text="电功率考核因素")


class OutLineSerializer(ModelSerializer):
    class Meta:
        model = Outline
        fields = ("id", "name")
