from django.db import models

# Create your models here.
from common.utils.models import BaseModel
from console.equipment.models import Equipment


class Dictionary(BaseModel):
    name = models.CharField(max_length=32, help_text="名称")
    value = models.TextField(help_text="枚举值")
    model = models.CharField(max_length=32, help_text="模块")
    equipment = models.ForeignKey(to=Equipment,
                                  on_delete=models.SET_NULL,
                                  null=True,
                                  help_text="关联设备")
    remarks = models.TextField(null=True, blank=True, help_text="备注")

    class Meta:
        db_table = "dictionary"
