from django.urls import path

from . import views

urlpatterns = [
    path('customers', views.CustomerInfoView.as_view()),
    path('cars', views.CarInfoView.as_view()),
    path('summary', views.SummaryView.as_view()),
    path('weather', views.WeatherInfoView.as_view()),
    path('statistics', views.StatisticsView.as_view()),
    path('numbers/<str:number_id>/details',
         views.CustomerDetailView.as_view()),
    path('monitor/<int:station_id>/videos', views.MonitorLView.as_view()),
    path('monitor/alarm', views.MonitorAlarmLView.as_view()),
    path('monitor/real_data', views.MonitorRealDataLView.as_view()),
    path('monitor/month_ep', views.MonitorMonthEPLView.as_view()),
    path('user_location', views.UserLocationView.as_view()),
    path('last_location', views.UserHistoryLocation.as_view()),
    path('data_analysis', views.ScoreView.as_view())
]
