#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging

from rest_framework import serializers
from rest_framework_jwt.settings import api_settings

logger = logging.getLogger('')
jwt_payload_handler = api_settings.JWT_PAYLOAD_HANDLER
jwt_encode_handler = api_settings.JWT_ENCODE_HANDLER


class CarSerializer(serializers.Serializer):
    longitude = serializers.CharField(max_length=16,
                                      allow_null=True,
                                      help_text="经度")
    latitude = serializers.CharField(max_length=16,
                                     allow_null=True,
                                     help_text="纬度")
    number_plate = serializers.CharField(max_length=32,
                                         allow_null=True,
                                         help_text="车牌号")
    name = serializers.CharField(max_length=32, help_text="名称")
    imei = serializers.CharField(max_length=32, help_text="imei号")
    # 0:静止 1:行驶 10:离线 20:未启用
    status = serializers.IntegerField(help_text="状态")


class UserSerializer(serializers.Serializer):
    longitude = serializers.CharField(max_length=16,
                                      allow_null=True,
                                      help_text="经度")
    latitude = serializers.CharField(max_length=16,
                                     allow_null=True,
                                     help_text="纬度")
    name = serializers.CharField(max_length=32, help_text="名称")
    id = serializers.IntegerField(help_text="id")
    # 0:静止 1:行驶 10:离线 20:未启用
    status = serializers.IntegerField(help_text="状态")


class CustomerSerializer(serializers.Serializer):
    id = serializers.IntegerField(help_text="id")
    name = serializers.CharField(max_length=32, help_text="名称")
    number = serializers.CharField(max_length=64, help_text="户号")
    longitude = serializers.CharField(max_length=16,
                                      allow_null=True,
                                      help_text="经度")
    latitude = serializers.CharField(max_length=16,
                                     allow_null=True,
                                     help_text="纬度")
    address = serializers.CharField(max_length=64, help_text="地址")
    adcode = serializers.IntegerField(help_text="行政编号")
    # 0:静止 1:行驶 10:离线 20:未启用
    status = serializers.NullBooleanField(help_text="状态", default=0)


class UserCarCustomerSerializer(serializers.Serializer):
    cars = CarSerializer(many=True)
    customer = CustomerSerializer(many=True)


class SummarySerializer(serializers.Serializer):
    number_count = serializers.IntegerField(help_text="签约客户户号数")
    station_count = serializers.IntegerField(help_text="签约客户电站数")
    monitor_device_count = serializers.IntegerField(help_text="监控设备数")
    capacity_count = serializers.IntegerField(help_text="装接容量")


class WeatherSerializer(serializers.Serializer):
    weather = serializers.CharField(max_length=32, help_text="天气")


class InspectionAchievementRateSerializer(serializers.Serializer):
    current_year_month = serializers.CharField(max_length=16, help_text="当前年月")
    month = serializers.IntegerField(help_text="当前月份")
    year = serializers.IntegerField(help_text="当前年份")
    completed = serializers.IntegerField(help_text="完成数量")
    total = serializers.IntegerField(help_text="全部数量")
    rate = serializers.IntegerField(help_text="（小数计）完成率")


class CommonStatisticsSerializer(serializers.Serializer):
    rate = InspectionAchievementRateSerializer(many=True)
    year_on_year = serializers.FloatField(help_text="年环比")
    month_on_month = serializers.FloatField(help_text="月环比")


class StatisticsSerializer(serializers.Serializer):
    inspection_achievement = CommonStatisticsSerializer()
    exception_handling = CommonStatisticsSerializer()


class MonitorVideoSerializer(serializers.Serializer):
    video = serializers.CharField(max_length=256)
    key = serializers.CharField(max_length=256, required=False)
