#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.urls import path

from . import views

urlpatterns = [
    path("", views.CustomerView.as_view()),
    path("/", views.CustomerView.as_view()),
    path("/total", views.CustomerInfoView.as_view()),
    path("/<int:id>", views.CustomerView.as_view()),
    path("/file", views.CustomerFileView.as_view()),
    path("/admin", views.CustomerAdminView.as_view()),
    path("/<int:customer_id>/admin/<int:id>", views.CustomerAdminDView.as_view()),
    path("/district", views.GetDistrictView.as_view()),
    path("/contact", views.ContactView.as_view()),
    path("/<int:customer_id>/contact/<int:id>", views.ContactDView.as_view()),
    path("/report", views.ReportLView.as_view()),
    path("/report/<int:electrical_user_id>", views.ReportRView.as_view()),
    path("/map", views.CustomerMapView.as_view()),
    path("/ele_map", views.CustomerElectricMapView.as_view()),
    path("/report/send", views.CustomerReportUploadView.as_view()),
    path("/report/pdf", views.CustomerReportPDFView.as_view()),
    path("/report/<int:id>/confirm", views.BasicConfirmView.as_view()),
    path("/supper_report/confirm", views.SupperConfirmView.as_view()),
    path("/map_list", views.MapLView.as_view()),
    path("/report/export", views.ReportExportView.as_view())
]
