from django.db import transaction
from console.contract.models import Contract
import time


class contractService(object):
    @transaction.atomic()
    def delete_contract(self, contract_id):
        Contract.objects.filter(id=contract_id).update(
            deleted=True,
            deleted_time=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()))

    @transaction.atomic()
    def delete_contracts(self, contracts):
        Contract.objects.filter(id__in=contracts).update(
            deleted=True,
            deleted_time=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()))


contract_service = contractService()
