from console.contract.models import Contract


class ContractQuerySet(object):
    @property
    def get_all_contract_info(self):
        return Contract.objects.filter(deleted=False).prefetch_related(
            'customer', 'business_entity', 'contract_party', 'salesman',
            'customer_contact')


class ContractInfo(object):
    def get_contract_info(self, contract_id):
        return Contract.objects.filter(deleted=False, id=contract_id).first()


contract_queryset = ContractQuerySet()
contract_info = ContractInfo()
