from django_filters import rest_framework as filter

from console.contract.models import Contract


class ContractFilter(filter.FilterSet):
    customer = filter.CharFilter(method="get_customer")

    def get_customer(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer__name__icontains=value)
        return queryset

    class Meta:
        model = Contract
        fields = ('type', 'code')
