import os

from rest_framework import serializers as serializer

from console.powerstation.models import PowerStation


class CircuitFileUploadSerializer(serializer.Serializer):
    file = serializer.FileField(required=True, allow_empty_file=False)
    station_id = serializer.IntegerField(required=True, allow_null=False)

    def validate(self, attrs):
        if os.path.splitext(attrs.get("file").name)[1] != ".dwg":
            raise serializer.ValidationError("只支持CAD图的dwg文件")
        power_station = PowerStation.objects.filter(
            deleted=False, id=attrs.get("station_id")).first()
        if not power_station:
            raise serializer.ValidationError("电站%s不存在" %
                                             attrs.get("station_id"))
        return attrs
