from django.urls import path

from console.APP import views

urlpatterns = [
    path("/settings/order", views.OrderSettingView.as_view()),
    path("/draft", views.DraftsCreateView.as_view()),
    path("/drafts", views.DraftsView.as_view()),
    path("/draft/<int:id>/info", views.DraftsInfoView.as_view()),
    path("/location", views.UserLocationView.as_view()),
    path("/test", views.TestApi.as_view()),
    path("/create_plan", views.CreateNormalInspectionTask.as_view()),
    path("/version_update/check", views.VersionUpdateStatus.as_view()),
    path("/version_update/update", views.UpdateVersion.as_view()),
    path("/version_update/create", views.CreateVersionMessage.as_view()),
    path("/new_version", views.AppVersionRView.as_view())
]
