from common.accounts.models import (Users, Roles, UserRoles, Tags, UserTags)


class UserQuerySet(object):
    @property
    def set_password(self):
        return Users.objects.filter(deleted=False, account__is_active=True)

    @property
    def users_lc(self):
        return Users.objects.filter(deleted=False, account__is_active=True)

    @property
    def roles_lc(self):
        return Roles.objects.filter(deleted=False)

    @property
    def user_roles_lc(self):
        return UserRoles.objects.filter(deleted=False)

    @property
    def tags_lc(self):
        return Tags.objects.filter(deleted=False)

    @property
    def user_tags_lc(self):
        return UserTags.objects.filter(deleted=False)


class UserRepo(object):
    def create_user_roles(self, user_id, role_ids):
        user_roles = map(lambda x: UserRoles(user_id=user_id, role_id=x),
                         role_ids)
        return UserRoles.objects.bulk_create(user_roles)

    def get_user_roles(self, user_id):
        return UserRoles.objects.filter(user_id=user_id)

    def get_user_tags(self, user_id):
        return UserTags.objects.filter(user_id=user_id)

    def create_user_tags(self, user_id, tag_ids):
        user_tags = map(lambda x: UserTags(user_id=user_id, tag_id=x), tag_ids)
        return UserTags.objects.bulk_create(user_tags)


user_queryset = UserQuerySet()
user_repo = UserRepo()
