#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.utils.translation import ugettext as _

ROLE_KIND = (
    ('enterprise', _(u'公司')),
    ('group', _(u'团队，组，部门')),
)

USER_STATUS = (
    (1, _(u'在职')),
    (2, _(u'离职')),
)

CERT_TYPE = (
    (1, _(u'身份证')),
    (2, _(u'护照')),
    (3, _(u'港澳居民来往内地通行证')),
    (4, _(u'台湾居民来往大陆通行证')),
    (5, _(u'外国人永久居留身份证')),
    (6, _(u'港澳台居民居住证')),
)

MONITOR_MANUFACTURER = ((1, _("安科瑞")), (2, _("中电")))

MONITOR_MODEL = ((1, _("ADW300-HJ-4G")), (2, _("350-E")))

MONITOR_NETWORK_TP = ((1, _("3G")), (2, _("4G")), (3, _("5G")), (4, _("WIFI")))

MONITOR_MANUFACTURER_METADATA = [{
    "id":
    1,
    "manufacturer":
    "安科瑞",
    "models": [{
        "id": 1,
        "name": "ADW300-HJ-4G",
    }]
}, {
    "id":
    2,
    "manufacturer":
    "中电",
    "models": [{
        "id": 2,
        "name": "350-E",
    }, {
        "id": 3,
        "name": "深圳中电",
    }]
}, {
    "id":
    3,
    "manufacturer":
    "万易",
    "models": [{
        "id": 4,
        "name": "万易老",
    }, {
        "id": 5,
        "name": "万易新",
    }]
}, {
    "id":
    4,
    "manufacturer":
    "数据科技",
    "models": [{
        "id": 6,
        "name": "数据科技GPRS",
    }, {
        "id": 7,
        "name": "数据科技WIFI",
    }]
}, {
    "id":
    5,
    "manufacturer":
        "虚拟高压",
    "models": [{
        "id": 8,
        "name": "虚拟高压",
    }]
}]

MONITOR_NETWORK_METADATA = [
    {
        "id": 1,
        "name": "3G",
    },
    {
        "id": 2,
        "name": "4G",
    },
    {
        "id": 3,
        "name": "5G",
    },
    {
        "id": 4,
        "name": "WIFI",
    },
]

MONITOR_DEVICE_STATUS = ((1, _("正常")), (2, _("断电")), (3, _("已拆回")))
MONITOR_POINT_STATUS = ((0, _("异常")), (1, _("正常")), (2, _("断电")))
MONITOR_ALARM_TYPE = ((1, _("电压异常")), (2, _("电流异常")), (3, _("负载异常")),
                      (4, _("设备断电")), (5, _("设备失联")), (6, _("单日上传率异常")))
MONITOR_ALARM_LEVEL = ((1, _("黄色告警")), (2, _("红色告警")))
MONITOR_ALARM_STATUS = ((1, _("未处理")), (2, _("已处理")))
# 0待审批 1已通过 2监控数据异常 3填报内容错误
MONITOR_DEVICE_RECORD_STATUS = ((0, _("待审批")), (1, _("已通过")), (2, _("监控数据异常")),
                                (3, _("填报内容错误")))

# 设备根类型
EQ_ROOT_TYPE = ((0, _("高压开关柜")), (1, _("变压器")), (2, _("400V开关柜")),
                (3, _("400V电容器柜")), (4, _("辅助屏")), (5, _("三相电能计量柜")), (6, _("线缆")))

# 设备根类型
EQ_TYPE = (
    (1001, _("高压常规开关柜")), (1002, _("高压充气开关柜")), (1003, _("400V开关柜")),
           (2001, _("电流互感器")), (2002, _("电压互感器")),
    (3001, _("多功能表")),
           (4001, _("真空断路器")), (4002, _("SF6断路器")), (4003, _("少油断路器")),
           (4004, _("微型断路器")), (4005, _("框架断路器")), (4006, _("塑壳断路器")),
           (5001, _("避雷器")),
    (6001, _("熔断器")),
    (7001, _("多功能表")),
           (8001, _("隔离开关刀闸")), (8002, _("负荷开关刀闸")), (8003, _("接地刀闸")),
           (9001, _("开关柜带电显示装置")), (9002, _("变压器带电显示")), (10001, _("温湿度装置")),
           (1101, _("触头盒")), (1102, _("套管")), (1103, _("绝缘支柱")), (1201,
                                                                  _("干式变压器")),
           (1202, _("油浸式变压器")), (1301, _("有载调压")), (1401, _("温控仪")), (1501,
                                                                      _("风机")),
           (1601, _("400V电容器柜")), (1701, _("控制器")), (1801, _("接触器")),
           (1901, _("电抗器")), (20001, _("直流屏")), (20002, _("通讯屏")), (20003,
                                                                  _("故障录波屏")),
           (20004, _("光端机屏")), (20005, _("其它辅助屏")), (20006, _("辅助屏充电模块")),
           (20007, _("辅助屏电池")), (20008, _("辅助屏电源稳压")), (20009, _("辅助屏分布式直流电源装置")),
           (20010, _("辅助屏模块")), (20011, _("辅助屏母块")), (20012, _("辅助屏显示屏")),
           (20013, _("辅助屏蓄电池")), (21001, _("三相电能计量柜")), (22001, _("馈线名称")),
           (22002, _("电池屏")),
           )
