from rest_framework import serializers


class FileUploadSerializers(serializers.Serializer):
    file = serializers.FileField(required=True, use_url=False)

    class Meta:
        fields = "file"


class FileSliceUploadSerializers(serializers.Serializer):
    file = serializers.FileField(required=True, use_url=False, help_text="文件")
    index = serializers.CharField(required=True,
                                  allow_null=False,
                                  help_text="索引")
    count = serializers.CharField(required=True,
                                  allow_null=False,
                                  help_text="总片数")
    md5 = serializers.CharField(required=True,
                                allow_null=False,
                                help_text="md5值")
    name = serializers.CharField(required=True,
                                 allow_null=False,
                                 help_text="文件名称")
