import json


class CallApiError(Exception):
    def __init__(self, msg, code, url=None, method=None, res=None):
        super(Exception).__init__(msg, code, url, method, res)
        self.message = {
            "msg": msg,
            "code": code,
            "url": url,
            "method": method,
            "body": (res.json() if res else None),
        }

    def __str__(self):
        return json.dumps(self.message)


class AuthorizationError(CallApiError):
    def __init__(self):
        super(AuthorizationError, self).__init__("Authorization Error", 401)
