from common.third_party_api.danbing.baseclient import (BaseClient, APIClient,
                                                       Configuration,
                                                       form_data)


class ZYRHApi(object):


    def __init__(self, host="139.196.168.11:81", data=form_data):
        self.client = BaseClient(
            APIClient(Configuration(host=host, data=data)))


    def get_hongqiao_device_gps(self, **kwargs):
        data = {
            "action": "getDeviceGps",
        }
        rst = self.client.post("/ajax/device.aspx", data=data, params=kwargs)
        return rst


    def get_tree(cls, **kwargs):
        data = {
            "action": "getTree",
        }
        rst = cls.client.post("/ajax/tree.aspx", data=data, params=kwargs)
        return rst


    def get_device_tree(cls, **kwargs):
        dt = {
            "count": 0,
            "list": [],
            "code": 10000,
        }
        devices = cls.get_hongqiao_device_gps()
        dt["count"] = devices["dataCount"]
        if devices["result"] != 1:
            dt["code"] = 40005

        for i in devices["list"]:
            status = "0"
            if i["s2"] == '1' or i["s3"] == '1':
                status = "1"
            gpstime = i["gpstime"].split("/")
            if len(gpstime[1]) == 1:
                gpstime[1] = "0" + gpstime[1]
            ts = gpstime[-1].split(" ")
            if len(ts[0]) == 1:
                gpstime[-1] = "0" + gpstime[-1]

            dt["list"].append({
                "id":
                    i["id"],
                "name":
                    i["name"],
                "code":
                    i["code"],
                "lat":
                    i["lat"],
                "lng":
                    i["lng"],
                "gpstime":
                    "-".join(gpstime),
                "status":
                    status,
                "video":
                    "http://139.196.168.11:23505/live/video.flv?"
                    "devid={}&channel=1&devline=0".format(i["code"]),
                "video_token":
                    None,
                "video_key":
                    None,
                "manufacturer":
                    "0",
            })
        return dt


    def get_device_history_video_list(cls, code):
        data = {"action": "getDeviceUploadFile", "devCode": code}
        dt = {
            "list": [],
            "count": 0,
        }
        rst = cls.client.post("/ajax/devUploadFile.aspx", data=data)
        for i in rst["list"]:
            dt["list"].append({
                "create_time":
                    i["createTime"],
                "video_size":
                    i["fileSize"],
                "video_path":
                    "http://139.196.168.11:23505/" + i["filePath"],
                "video_ext":
                    i["fileExt"],
                "manufacturer":
                    "0",
            })
        dt["count"] = rst["dataCount"]
        return dt

    def __str__(self):
        return "ZYRHApi"

# print(ZYRHApi.get_device_history_video_list("dgj05"))
