from common.third_party_api.amap.baseclient import Configuration, APIClient, BaseClient

class AmapApi(object):
    def __init__(self):
        configuration = Configuration(host="restapi.amap.com",
                                      key="ad81ef1d6b0b8e5c29d0040f1ac66c84")
        self.client = BaseClient(APIClient(configuration))

    def geo(self, **kwargs):
        """
        地理编码
        :param address: 地址
        :param city: 城市
        :param batch: 是否批量查询
        """
        return self.client.get("/v3/geocode/geo", params=kwargs)

    def regeo(self, **kwargs):
        """
        逆地理编码
        :param address: 地址
        :param city: 城市
        :param batch: 是否批量查询
        """
        return self.client.get("/v3/geocode/regeo", params=kwargs)

    def district(self, **kwargs):
        """
        行政区域查询
        :param address: 地址
        :param city: 城市
        :param batch: 是否批量查询
        """
        return self.client.get("/v3/config/district", params=kwargs)

    def ip(self, **kwargs):
        """
        ip定位
        :param address: 地址
        :param city: 城市
        :param batch: 是否批量查询
        """
        return self.client.get("/v3/ip", params=kwargs)

    def weather(self, **kwargs):
        """
        天气查询
        :param address: 地址
        :param city: 城市
        :param batch: 是否批量查询
        """
        return self.client.get("/v3/weather/weatherInfo", params=kwargs)
