from common.forms.models import Form
from common.forms.serializers import FormCreateSerializer
from common.utils.views import ManagerApiView
from rest_framework.response import Response

from common.utils.return_structure import general_message, error_message
from common.utils.service_code import API_ERROR


class FormCreateView(ManagerApiView):
    queryset = Form.objects.filter(deleted=False)
    serializer_class = FormCreateSerializer

    def post(self, request, *args, **kwargs):
        serialzier = FormCreateSerializer(data=request.data)
        if serialzier.is_valid():
            serialzier.save()
            return Response(general_message(msg_show="表格创建成功"))
        return Response(
            error_message(msg_show="表创建失败",
                          msg=serialzier.errors,
                          code=API_ERROR))
