# import datetime

from celery import Celery

# from common.notify.message import MessageObject
# from django.conf import settings
import logging

LOG = logging.getLogger()


def my_monitor(app):
    state = app.events.State()

    def announce_failed_tasks(event):
        state.event(event)
        # task name is sent only with -received event, and state
        # will keep track of this for us.
        task = state.tasks.get(event['uuid'])
        # sms = MessageObject()
        # sms.send_sms_multi(settings.CELERY_NOTIFY_PHONE,
        #                    "818596",
        #                    param_list=[task.name,
        #                                datetime.datetime.now()])
        print('TASK FAILED: %s[%s] %s' % (
            task.name,
            task.uuid,
            task.info(),
        ))
        LOG.error('TASK FAILED: %s[%s] %s' % (
            task.name,
            task.uuid,
            task.info(),
        ))

    def announce_receive_tasks(event):
        state.event(event)
        # task name is sent only with -received event, and state
        # will keep track of this for us.
        task = state.tasks.get(event['uuid'])

        print('TASK RECEIVED: %s[%s] %s' % (
            task.name,
            task.uuid,
            task.info(),
        ))
        LOG.info('TASK RECEIVED: %s[%s] %s' % (
            task.name,
            task.uuid,
            task.info(),
        ))

    def announce_start_tasks(event):
        state.event(event)
        task = state.tasks.get(event['uuid'])
        print("task start %s[%s] %s" % (
            task.name,
            task.uuid,
            task.info(),
        ))
        LOG.info('TASK RECEIVED: %s[%s] %s' % (
            task.name,
            task.uuid,
            task.info(),
        ))

    with app.connection() as connection:
        recv = app.events.Receiver(connection,
                                   handlers={
                                       'task-failed': announce_failed_tasks,
                                       'task-received': announce_receive_tasks,
                                       'task-started': announce_start_tasks,
                                       '*': state.event,
                                   })
        recv.capture(limit=None, timeout=None, wakeup=True)


if __name__ == '__main__':
    print('monitor start')
    app = Celery(broker='redis://127.0.0.1:6379/1')
    my_monitor(app)
